/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class CpuStats {
    @JsonProperty(value="cpu_usage")
    private CpuUsage cpuUsage;
    @JsonProperty(value="system_cpu_usage")
    private Long systemCpuUsage;
    @JsonProperty(value="throttling_data")
    private ThrottlingData throttlingData;

    public CpuUsage cpuUsage() {
        return this.cpuUsage;
    }

    public Long systemCpuUsage() {
        return this.systemCpuUsage;
    }

    public ThrottlingData throttlingData() {
        return this.throttlingData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CpuStats that = (CpuStats)o;
        return Objects.equals(this.cpuUsage, that.cpuUsage) && Objects.equals(this.systemCpuUsage, that.systemCpuUsage) && Objects.equals(this.throttlingData, that.throttlingData);
    }

    public int hashCode() {
        return Objects.hash(this.cpuUsage, this.systemCpuUsage, this.throttlingData);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cpuUsage", (Object)this.cpuUsage).add("systemCpuUsage", (Object)this.systemCpuUsage).add("throttlingData", (Object)this.throttlingData).toString();
    }

    public static class CpuUsage {
        @JsonProperty(value="total_usage")
        private Long totalUsage;
        @JsonProperty(value="percpu_usage")
        private ImmutableList<Long> percpuUsage;
        @JsonProperty(value="usage_in_kernelmode")
        private Long usageInKernelmode;
        @JsonProperty(value="usage_in_usermode")
        private Long usageInUsermode;

        public Long totalUsage() {
            return this.totalUsage;
        }

        public ImmutableList<Long> percpuUsage() {
            return this.percpuUsage;
        }

        public Long usageInKernelmode() {
            return this.usageInKernelmode;
        }

        public Long usageInUsermode() {
            return this.usageInUsermode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CpuUsage that = (CpuUsage)o;
            return Objects.equals(this.totalUsage, that.totalUsage) && Objects.equals(this.percpuUsage, that.percpuUsage) && Objects.equals(this.usageInKernelmode, that.usageInKernelmode) && Objects.equals(this.usageInUsermode, that.usageInUsermode);
        }

        public int hashCode() {
            return Objects.hash(this.totalUsage, this.percpuUsage, this.usageInKernelmode, this.usageInUsermode);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("percpuUsage", this.percpuUsage).add("totalUsage", (Object)this.totalUsage).add("usageInKernelmode", (Object)this.usageInKernelmode).add("usageInUsermode", (Object)this.usageInUsermode).toString();
        }
    }

    public static class ThrottlingData {
        @JsonProperty(value="periods")
        private Long periods;
        @JsonProperty(value="throttled_periods")
        private Long throttledPeriods;
        @JsonProperty(value="throttled_time")
        private Long throttledTime;

        public Long throttledTime() {
            return this.throttledTime;
        }

        public Long throttledPeriods() {
            return this.throttledPeriods;
        }

        public Long periods() {
            return this.periods;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThrottlingData that = (ThrottlingData)o;
            return Objects.equals(this.periods, that.periods) && Objects.equals(this.throttledPeriods, that.throttledPeriods) && Objects.equals(this.throttledTime, that.throttledTime);
        }

        public int hashCode() {
            return Objects.hash(this.periods, this.throttledPeriods, this.throttledTime);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("periods", (Object)this.periods).add("throttledPeriods", (Object)this.throttledPeriods).add("throttledTime", (Object)this.throttledTime).toString();
        }
    }
}

