/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Info {
    @JsonProperty(value="Architecture")
    private String architecture;
    @JsonProperty(value="ClusterStore")
    private String clusterStore;
    @JsonProperty(value="CgroupDriver")
    private String cgroupDriver;
    @JsonProperty(value="Containers")
    private int containers;
    @JsonProperty(value="ContainersRunning")
    private Integer containersRunning;
    @JsonProperty(value="ContainersStopped")
    private Integer containersStopped;
    @JsonProperty(value="ContainersPaused")
    private Integer containersPaused;
    @JsonProperty(value="CpuCfsPeriod")
    private Boolean cpuCfsPeriod;
    @JsonProperty(value="CpuCfsQuota")
    private Boolean cpuCfsQuota;
    @JsonProperty(value="Debug")
    private Boolean debug;
    @JsonProperty(value="DockerRootDir")
    private String dockerRootDir;
    @JsonProperty(value="Driver")
    private String storageDriver;
    @JsonProperty(value="DriverStatus")
    private List<List<String>> driverStatus;
    @JsonProperty(value="ExecutionDriver")
    private String executionDriver;
    @JsonProperty(value="ExperimentalBuild")
    private Boolean experimentalBuild;
    @JsonProperty(value="HttpProxy")
    private String httpProxy;
    @JsonProperty(value="HttpsProxy")
    private String httpsProxy;
    @JsonProperty(value="ID")
    private String id;
    @JsonProperty(value="IPv4Forwarding")
    private boolean ipv4Forwarding;
    @JsonProperty(value="Images")
    private int images;
    @JsonProperty(value="IndexServerAddress")
    private String indexServerAddress;
    @JsonProperty(value="InitPath")
    private String initPath;
    @JsonProperty(value="InitSha1")
    private String initSha1;
    @JsonProperty(value="KernelMemory")
    private Boolean kernelMemory;
    @JsonProperty(value="KernelVersion")
    private String kernelVersion;
    @JsonProperty(value="Labels")
    private List<String> labels;
    @JsonProperty(value="MemTotal")
    private long memTotal;
    @JsonProperty(value="MemoryLimit")
    private Boolean memoryLimit;
    @JsonProperty(value="NCPU")
    private int cpus;
    @JsonProperty(value="NEventsListener")
    private int eventsListener;
    @JsonProperty(value="NFd")
    private int fileDescriptors;
    @JsonProperty(value="NGoroutines")
    private int goroutines;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="NoProxy")
    private String noProxy;
    @JsonProperty(value="OomKillDisable")
    private Boolean oomKillDisable;
    @JsonProperty(value="OperatingSystem")
    private String operatingSystem;
    @JsonProperty(value="OSType")
    private String osType;
    @JsonProperty(value="Plugins")
    private Plugins plugins;
    @JsonProperty(value="RegistryConfig")
    private RegistryConfig registryConfig;
    @JsonProperty(value="ServerVersion")
    private String serverVersion;
    @JsonProperty(value="SwapLimit")
    private Boolean swapLimit;
    @JsonProperty(value="SystemStatus")
    private List<List<String>> systemStatus;
    @JsonProperty(value="SystemTime")
    private Date systemTime;

    public String architecture() {
        return this.architecture;
    }

    public String clusterStore() {
        return this.clusterStore;
    }

    public String cgroupDriver() {
        return this.cgroupDriver;
    }

    public int containers() {
        return this.containers;
    }

    public Integer containersRunning() {
        return this.containersRunning;
    }

    public Integer containersStopped() {
        return this.containersStopped;
    }

    public Integer containersPaused() {
        return this.containersPaused;
    }

    public Boolean cpuCfsPeriod() {
        return this.cpuCfsPeriod;
    }

    public Boolean cpuCfsQuota() {
        return this.cpuCfsQuota;
    }

    public Boolean debug() {
        return this.debug;
    }

    public String dockerRootDir() {
        return this.dockerRootDir;
    }

    public String storageDriver() {
        return this.storageDriver;
    }

    public List<List<String>> driverStatus() {
        return this.driverStatus;
    }

    @Deprecated
    public String executionDriver() {
        return this.executionDriver;
    }

    public Boolean experimentalBuild() {
        return this.experimentalBuild;
    }

    public String httpProxy() {
        return this.httpProxy;
    }

    public String httpsProxy() {
        return this.httpsProxy;
    }

    public String id() {
        return this.id;
    }

    public boolean ipv4Forwarding() {
        return this.ipv4Forwarding;
    }

    public int images() {
        return this.images;
    }

    public String indexServerAddress() {
        return this.indexServerAddress;
    }

    public String initPath() {
        return this.initPath;
    }

    public String initSha1() {
        return this.initSha1;
    }

    public Boolean kernelMemory() {
        return this.kernelMemory;
    }

    public String kernelVersion() {
        return this.kernelVersion;
    }

    public List<String> labels() {
        return this.labels;
    }

    public long memTotal() {
        return this.memTotal;
    }

    public Boolean memoryLimit() {
        return this.memoryLimit;
    }

    public int cpus() {
        return this.cpus;
    }

    public int eventsListener() {
        return this.eventsListener;
    }

    public int fileDescriptors() {
        return this.fileDescriptors;
    }

    public int goroutines() {
        return this.goroutines;
    }

    public String name() {
        return this.name;
    }

    public String noProxy() {
        return this.noProxy;
    }

    public Boolean oomKillDisable() {
        return this.oomKillDisable;
    }

    public String operatingSystem() {
        return this.operatingSystem;
    }

    public String osType() {
        return this.osType;
    }

    public Plugins plugins() {
        return this.plugins;
    }

    public RegistryConfig registryConfig() {
        return this.registryConfig;
    }

    public String serverVersion() {
        return this.serverVersion;
    }

    public Boolean swapLimit() {
        return this.swapLimit;
    }

    public List<List<String>> systemStatus() {
        return this.systemStatus;
    }

    public Date systemTime() {
        return this.systemTime == null ? null : new Date(this.systemTime.getTime());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Info that = (Info)o;
        return Objects.equals(this.architecture, that.architecture) && Objects.equals(this.clusterStore, that.clusterStore) && Objects.equals(this.cgroupDriver, that.cgroupDriver) && Objects.equals(this.containers, that.containers) && Objects.equals(this.containersRunning, that.containersRunning) && Objects.equals(this.containersStopped, that.containersStopped) && Objects.equals(this.containersPaused, that.containersPaused) && Objects.equals(this.cpuCfsPeriod, that.cpuCfsPeriod) && Objects.equals(this.cpuCfsQuota, that.cpuCfsQuota) && Objects.equals(this.cpus, that.cpus) && Objects.equals(this.debug, that.debug) && Objects.equals(this.dockerRootDir, that.dockerRootDir) && Objects.equals(this.driverStatus, that.driverStatus) && Objects.equals(this.eventsListener, that.eventsListener) && Objects.equals(this.executionDriver, that.executionDriver) && Objects.equals(this.experimentalBuild, that.experimentalBuild) && Objects.equals(this.fileDescriptors, that.fileDescriptors) && Objects.equals(this.goroutines, that.goroutines) && Objects.equals(this.httpProxy, that.httpProxy) && Objects.equals(this.httpsProxy, that.httpsProxy) && Objects.equals(this.id, that.id) && Objects.equals(this.images, that.images) && Objects.equals(this.indexServerAddress, that.indexServerAddress) && Objects.equals(this.initPath, that.initPath) && Objects.equals(this.initSha1, that.initSha1) && Objects.equals(this.ipv4Forwarding, that.ipv4Forwarding) && Objects.equals(this.kernelVersion, that.kernelVersion) && Objects.equals(this.labels, that.labels) && Objects.equals(this.memoryLimit, that.memoryLimit) && Objects.equals(this.memTotal, that.memTotal) && Objects.equals(this.name, that.name) && Objects.equals(this.noProxy, that.noProxy) && Objects.equals(this.oomKillDisable, that.oomKillDisable) && Objects.equals(this.operatingSystem, that.operatingSystem) && Objects.equals(this.osType, that.osType) && Objects.equals(this.plugins, that.plugins) && Objects.equals(this.registryConfig, that.registryConfig) && Objects.equals(this.serverVersion, that.serverVersion) && Objects.equals(this.storageDriver, that.storageDriver) && Objects.equals(this.swapLimit, that.swapLimit) && Objects.equals(this.systemStatus, that.systemStatus) && Objects.equals(this.systemTime, that.systemTime);
    }

    public int hashCode() {
        return Objects.hash(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.cpus, this.debug, this.dockerRootDir, this.driverStatus, this.eventsListener, this.executionDriver, this.experimentalBuild, this.fileDescriptors, this.goroutines, this.httpProxy, this.httpsProxy, this.id, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.ipv4Forwarding, this.kernelMemory, this.kernelVersion, this.labels, this.memoryLimit, this.memTotal, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.storageDriver, this.swapLimit, this.systemStatus, this.systemTime);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("architecture", (Object)this.architecture).add("clusterStore", (Object)this.clusterStore).add("cgroupDriver", (Object)this.cgroupDriver).add("containers", this.containers).add("containersRunning", (Object)this.containersRunning).add("containersStopped", (Object)this.containersStopped).add("containersPaused", (Object)this.containersPaused).add("cpuCfsPeriod", (Object)this.cpuCfsPeriod).add("cpuCfsQuota", (Object)this.cpuCfsQuota).add("debug", (Object)this.debug).add("dockerRootDir", (Object)this.dockerRootDir).add("storageDriver", (Object)this.storageDriver).add("driverStatus", this.driverStatus).add("executionDriver", (Object)this.executionDriver).add("experimentalBuild", (Object)this.experimentalBuild).add("httpProxy", (Object)this.httpProxy).add("httpsProxy", (Object)this.httpsProxy).add("id", (Object)this.id).add("ipv4Forwarding", this.ipv4Forwarding).add("images", this.images).add("indexServerAddress", (Object)this.indexServerAddress).add("initPath", (Object)this.initPath).add("initSha1", (Object)this.initSha1).add("kernelMemory", (Object)this.kernelMemory).add("kernelVersion", (Object)this.kernelVersion).add("labels", this.labels).add("memTotal", this.memTotal).add("memoryLimit", (Object)this.memoryLimit).add("cpus", this.cpus).add("eventsListener", this.eventsListener).add("fileDescriptors", this.fileDescriptors).add("goroutines", this.goroutines).add("name", (Object)this.name).add("noProxy", (Object)this.noProxy).add("oomKillDisable", (Object)this.oomKillDisable).add("operatingSystem", (Object)this.operatingSystem).add("osType", (Object)this.osType).add("plugins", (Object)this.plugins).add("registryConfig", (Object)this.registryConfig).add("serverVersion", (Object)this.serverVersion).add("swapLimit", (Object)this.swapLimit).add("systemStatus", this.systemStatus).add("systemTime", (Object)this.systemTime).toString();
    }

    public static class IndexConfig {
        @JsonProperty(value="Name")
        private String name;
        @JsonProperty(value="Mirrors")
        private List<String> mirrors;
        @JsonProperty(value="Secure")
        private Boolean secure;
        @JsonProperty(value="Official")
        private Boolean official;

        @JsonCreator
        public IndexConfig() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexConfig that = (IndexConfig)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.mirrors, that.mirrors) && Objects.equals(this.secure, that.secure) && Objects.equals(this.official, that.official);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.mirrors, this.secure, this.official);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("mirrors", this.mirrors).add("secure", (Object)this.secure).add("official", (Object)this.official).toString();
        }
    }

    public static class Plugins {
        @JsonProperty(value="Volumes")
        private ImmutableList<String> volume;
        @JsonProperty(value="Networks")
        private ImmutableList<String> network;

        public List<String> volume() {
            return this.volume;
        }

        public List<String> network() {
            return this.network;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Plugins that = (Plugins)o;
            return Objects.equals(this.volume, that.volume) && Objects.equals(this.network, that.network);
        }

        public int hashCode() {
            return Objects.hash(this.volume, this.network);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("volume", this.volume).add("network", this.network).toString();
        }
    }

    public static class RegistryConfig {
        @JsonProperty(value="IndexConfigs")
        private ImmutableMap<String, IndexConfig> indexConfigs;
        @JsonProperty(value="InsecureRegistryCIDRs")
        private ImmutableList<String> insecureRegistryCidrs;

        public Map<String, IndexConfig> indexConfigs() {
            return this.indexConfigs;
        }

        public List<String> insecureRegistryCidrs() {
            return this.insecureRegistryCidrs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegistryConfig that = (RegistryConfig)o;
            return Objects.equals(this.indexConfigs, that.indexConfigs) && Objects.equals(this.insecureRegistryCidrs, that.insecureRegistryCidrs);
        }

        public int hashCode() {
            return Objects.hash(this.indexConfigs, this.insecureRegistryCidrs);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("indexConfigs", this.indexConfigs).add("insecureRegistryCidrs", this.insecureRegistryCidrs).toString();
        }
    }
}

