/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.TextPropertyDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TextAndButtonSection
extends Section {
    protected int width = -1;
    protected boolean fillText = false;
    protected TextPropertyDescriptor textField;
    protected Button button;
    private String buttonText;
    IDescriptorProvider provider;
    protected List selectList = new ArrayList();
    protected int buttonWidth = 60;
    protected boolean isComputeSize = false;
    private String oldValue;
    private String buttonTooltipText;

    public TextAndButtonSection(String labelText, Composite parent, boolean isFormStyle) {
        super(labelText, parent, isFormStyle);
    }

    @Override
    public void createSection() {
        if (this.selectList == null) {
            this.selectList = new ArrayList();
        }
        this.getLabelControl(this.parent);
        this.getTextControl(this.parent);
        this.getButtonControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    @Override
    public void layout() {
        GridData gd = (GridData)this.textField.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - 2 - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - 2 - this.placeholder;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillText;
        }
        gd = (GridData)this.button.getLayoutData();
        if (this.buttonWidth > -1) {
            gd.widthHint = !this.isComputeSize ? Math.max(this.button.computeSize((int)-1, (int)-1).x, this.buttonWidth) : this.button.computeSize((int)-1, (int)-1).x;
        }
    }

    public TextPropertyDescriptor getTextControl() {
        return this.textField;
    }

    protected TextPropertyDescriptor getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = DescriptorToolkit.createTextPropertyDescriptor(true);
            if (this.getProvider() != null) {
                this.textField.setDescriptorProvider(this.getProvider());
            }
            this.textField.createControl(parent);
            this.textField.getControl().setLayoutData((Object)new GridData());
            this.textField.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TextAndButtonSection.this.textField = null;
                }
            });
        } else {
            this.checkParent(this.textField.getControl(), parent);
        }
        return this.textField;
    }

    public Button getButtonControl() {
        return this.button;
    }

    protected Button getButtonControl(Composite parent) {
        if (this.button == null) {
            this.button = FormWidgetFactory.getInstance().createButton(parent, 8, this.isFormStyle);
            this.button.setFont(parent.getFont());
            this.button.setLayoutData((Object)new GridData());
            String text = this.getButtonText();
            if (text != null) {
                this.button.setText(text);
            }
            if ((text = this.getButtonTooltipText()) != null) {
                this.button.setToolTipText(text);
            }
            this.button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TextAndButtonSection.this.button = null;
                }
            });
            if (!this.selectList.isEmpty()) {
                this.button.addSelectionListener((SelectionListener)this.selectList.get(0));
            } else {
                SelectionAdapter listener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TextAndButtonSection.this.onClickButton();
                    }
                };
                this.selectList.add(listener);
            }
        } else {
            this.checkParent((Control)this.button, parent);
        }
        return this.button;
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.textField != null) {
            this.textField.setDescriptorProvider(provider);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        if (!this.selectList.contains(listener)) {
            if (!this.selectList.isEmpty()) {
                this.removeSelectionListener((SelectionListener)this.selectList.get(0));
            }
            this.selectList.add(listener);
            if (this.button != null) {
                this.button.addSelectionListener(listener);
            }
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.selectList.contains(listener)) {
            this.selectList.remove(listener);
            if (this.button != null) {
                this.button.removeSelectionListener(listener);
            }
        }
    }

    protected void onClickButton() {
    }

    public void forceFocus() {
        this.textField.getControl().forceFocus();
    }

    @Override
    public void setInput(Object input) {
        this.textField.setInput(input);
    }

    @Override
    public void load() {
        if (this.textField != null && !this.textField.getControl().isDisposed()) {
            this.textField.load();
        }
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setEnabled(!this.isReadOnly());
        }
    }

    public void setButtonWidth(int buttonWidth) {
        this.buttonWidth = buttonWidth;
        if (this.button != null) {
            GridData data = new GridData();
            data.widthHint = Math.max(this.button.computeSize((int)-1, (int)-1).x, buttonWidth);
            data.grabExcessHorizontalSpace = false;
            this.button.setLayoutData((Object)data);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getButtonWidth() {
        return this.buttonWidth;
    }

    public void setStringValue(String value) {
        if (this.textField != null) {
            if (value == null) {
                value = "";
            }
            this.oldValue = this.textField.getText();
            if (!this.oldValue.equals(value)) {
                this.textField.setText(value);
            }
        }
    }

    public boolean isFillText() {
        return this.fillText;
    }

    public void setFillText(boolean fillText) {
        this.fillText = fillText;
    }

    @Override
    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, (boolean)isHidden);
        }
        if (this.textField != null) {
            this.textField.setHidden(isHidden);
        }
        if (this.button != null) {
            WidgetUtil.setExcludeGridData((Control)this.button, (boolean)isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, (boolean)isHidden);
        }
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.textField != null) {
            this.textField.setVisible(isVisible);
        }
        if (this.button != null) {
            this.button.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }

    public void setButtonTooltipText(String string) {
        this.buttonTooltipText = string;
        if (this.button != null) {
            this.button.setText(this.buttonTooltipText);
        }
    }

    public String getButtonText() {
        return this.buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
        if (this.button != null) {
            this.button.setText(buttonText);
        }
    }

    public String getButtonTooltipText() {
        return this.buttonTooltipText;
    }

    public boolean buttonIsComputeSize() {
        return this.isComputeSize;
    }

    public void setButtonIsComputeSize(boolean isComputeSize) {
        this.isComputeSize = isComputeSize;
    }
}

