/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.BaseResourceEntity;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class FilePathEntry
extends BaseResourceEntity {
    protected Logger logger = Logger.getLogger(FilePathEntry.class.getName());
    private String path;
    private URL url;
    private String name;
    private String displayName;
    private FileFilter filter;
    private FilePathEntry parent;
    private boolean isFolder;
    private boolean isRoot;
    private LibraryHandle library;
    private ArrayList childrenList;
    private boolean isFile;

    public FilePathEntry(String filePath) {
        this(filePath, null, true);
    }

    public FilePathEntry(String filePath, boolean showFiles) {
        this(filePath, null, showFiles);
    }

    public FilePathEntry(String filePath, String[] filePattern) {
        this(filePath, filePattern, true);
    }

    public FilePathEntry(String filePath, final String[] filePattern, final boolean showFiles) {
        this.filter = filePattern != null ? new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                int i = 0;
                while (i < filePattern.length) {
                    String[] regs = filePattern[i].split(";");
                    int j = 0;
                    while (j < regs.length) {
                        if (pathname.getName().toLowerCase().endsWith(regs[j].toLowerCase().substring(1))) {
                            return true;
                        }
                        ++j;
                    }
                    ++i;
                }
                return false;
            }
        } : new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                return showFiles;
            }
        };
        this.name = filePath;
        this.displayName = new File(filePath).getName();
        this.isRoot = true;
        this.initRoot(filePath);
    }

    private FilePathEntry(String path, String name, FilePathEntry parent) {
        this.path = path;
        this.name = name;
        this.parent = parent;
        this.filter = parent.filter;
        try {
            File file = new File(this.path);
            this.isFolder = file.isDirectory();
            this.url = file.toURL();
            this.isFile = file.isFile();
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private void initRoot(String path) {
        this.path = path;
        if (this.path != null) {
            try {
                File file = new File(this.path);
                this.isFolder = file.isDirectory();
                this.url = file.toURL();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean hasChildren() {
        File file = new File(this.path);
        if (file.isDirectory()) {
            String[] list = file.list();
            if (list == null) {
                return false;
            }
            return file.list().length > 0;
        }
        return false;
    }

    @Override
    public ResourceEntry[] getChildren() {
        if (this.childrenList == null) {
            this.childrenList = new ArrayList();
            try {
                File[] children;
                File file = new File(this.path);
                if (file.isDirectory() && (children = file.listFiles(this.filter)) != null) {
                    int i = 0;
                    while (i < children.length) {
                        FilePathEntry child = new FilePathEntry(children[i].getAbsolutePath(), children[i].getName(), this);
                        this.childrenList.add(child);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return this.childrenList.toArray(new ResourceEntry[this.childrenList.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Image getImage() {
        if (this.isRoot) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }
        if (this.isFolder) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        return super.getImage();
    }

    @Override
    public ResourceEntry getParent() {
        return this.parent;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public boolean isFile() {
        return this.isFile;
    }

    @Override
    public boolean isRoot() {
        return this.isRoot;
    }

    @Override
    public void dispose() {
        if (this.library != null) {
            this.library.close();
            this.library = null;
        }
        if (this.childrenList != null) {
            for (ResourceEntry entry : this.childrenList) {
                entry.dispose();
            }
        }
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == LibraryHandle.class && this.getURL().toString().toLowerCase().endsWith("library")) {
            if (!this.isFolder && this.library == null) {
                try {
                    this.library = SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(this.getURL().toString());
                }
                catch (DesignFileException designFileException) {}
            }
            return this.library;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof FilePathEntry)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        FilePathEntry temp = (FilePathEntry)object;
        return temp.path.equals(this.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

