/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TOCHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.interfaces.IGroupElementModel;

public abstract class GroupHandle
extends ReportElementHandle
implements IGroupElementModel {
    public GroupHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public SlotHandle getHeader() {
        return this.getSlot(0);
    }

    public SlotHandle getFooter() {
        return this.getSlot(1);
    }

    public String getKeyExpr() {
        return this.getStringProperty("keyExpr");
    }

    @Override
    public String getName() {
        return this.getStringProperty("groupName");
    }

    @Override
    public void setName(String theName) throws NameException {
        block3: {
            try {
                this.setProperty("groupName", StringUtil.trimString(theName));
            }
            catch (NameException e) {
                throw e;
            }
            catch (SemanticException semanticException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public void setKeyExpr(String expr) throws SemanticException {
        this.setProperty("keyExpr", expr);
    }

    public Iterator sortsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("sort");
        assert (propHandle != null);
        return propHandle.iterator();
    }

    public Iterator filtersIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("filter");
        assert (propHandle != null);
        return propHandle.iterator();
    }

    public void setGroupStart(String groupStart) throws SemanticException {
        this.setIntervalBase(groupStart);
    }

    public String getGroupStart() {
        return this.getIntervalBase();
    }

    public void setIntervalBase(String intervalBase) throws SemanticException {
        this.setStringProperty("intervalBase", intervalBase);
    }

    public String getIntervalBase() {
        return this.getStringProperty("intervalBase");
    }

    public String getInterval() {
        return this.getStringProperty("interval");
    }

    public void setInterval(String interval) throws SemanticException {
        this.setStringProperty("interval", interval);
    }

    public double getIntervalRange() {
        return this.getFloatProperty("intervalRange");
    }

    public void setIntervalRange(double intervalRange) throws SemanticException {
        this.setFloatProperty("intervalRange", intervalRange);
    }

    public void setIntervalRange(String intervalRange) throws SemanticException {
        this.setStringProperty("intervalRange", intervalRange);
    }

    public String getSortDirection() {
        return this.getStringProperty("sortDirection");
    }

    public void setSortDirection(String direction) throws SemanticException {
        this.setStringProperty("sortDirection", direction);
    }

    public boolean hasHeader() {
        return this.getHeader().getCount() != 0;
    }

    public boolean hasFooter() {
        return this.getFooter().getCount() != 0;
    }

    public void setTocExpression(String expression) throws SemanticException {
        if (StringUtil.isEmpty(expression)) {
            this.setProperty("toc", null);
            return;
        }
        TOCHandle tocHandle = this.getTOC();
        if (tocHandle == null) {
            TOC toc = StructureFactory.createTOC(expression);
            this.addTOC(toc);
        } else {
            tocHandle.setExpression(expression);
        }
    }

    public String getTocExpression() {
        TOCHandle tocHandle = this.getTOC();
        if (tocHandle == null) {
            return null;
        }
        return tocHandle.getExpression();
    }

    public void setSortType(String sortType) throws SemanticException {
        this.setStringProperty("sortType", sortType);
    }

    public String getSortType() {
        return this.getStringProperty("sortType");
    }

    public String getOnPrepare() {
        return this.getStringProperty("onPrepare");
    }

    public void setOnPrepare(String script) throws SemanticException {
        this.setProperty("onPrepare", script);
    }

    public boolean repeatHeader() {
        return this.getBooleanProperty("repeatHeader");
    }

    public void setRepeatHeader(boolean value) throws SemanticException {
        this.setBooleanProperty("repeatHeader", value);
    }

    public String getPageBreakAfter() {
        return this.getStringProperty("pageBreakAfter");
    }

    public void setPageBreakAfter(String value) throws SemanticException {
        this.setProperty("pageBreakAfter", value);
    }

    public String getPageBreakInside() {
        return this.getStringProperty("pageBreakInside");
    }

    public void setPageBreakInside(String value) throws SemanticException {
        this.setProperty("pageBreakInside", value);
    }

    public String getPageBreakBefore() {
        return this.getStringProperty("pageBreakBefore");
    }

    public void setPageBreakBefore(String value) throws SemanticException {
        this.setProperty("pageBreakBefore", value);
    }

    public boolean hideDetail() {
        return this.getBooleanProperty("hideDetail");
    }

    public void setHideDetail(boolean value) throws SemanticException {
        this.setBooleanProperty("hideDetail", value);
    }

    public String getOnPageBreak() {
        return this.getStringProperty("onPageBreak");
    }

    public void setOnPageBreak(String script) throws SemanticException {
        this.setProperty("onPageBreak", script);
    }

    public String getOnCreate() {
        return this.getStringProperty("onCreate");
    }

    public void setOnCreate(String script) throws SemanticException {
        this.setProperty("onCreate", script);
    }

    public String getOnRender() {
        return this.getStringProperty("onRender");
    }

    public void setOnRender(String script) throws SemanticException {
        this.setProperty("onRender", script);
    }

    public Iterator columnBindingsIterator() {
        return Collections.EMPTY_LIST.iterator();
    }

    public PropertyHandle getColumnBindings() {
        return null;
    }

    public ComputedColumnHandle addColumnBinding(ComputedColumn addColumn, boolean inForce) throws SemanticException {
        return null;
    }

    public TOCHandle getTOC() {
        PropertyHandle propHandle = this.getPropertyHandle("toc");
        TOC toc = (TOC)propHandle.getValue();
        if (toc == null) {
            return null;
        }
        return (TOCHandle)toc.getHandle(propHandle);
    }

    public TOCHandle addTOC(String expression) throws SemanticException {
        if (StringUtil.isEmpty(expression)) {
            return null;
        }
        TOC toc = StructureFactory.createTOC(expression);
        this.setProperty("toc", toc);
        return (TOCHandle)toc.getHandle(this.getPropertyHandle("toc"));
    }

    public TOCHandle addTOC(TOC toc) throws SemanticException {
        this.setProperty("toc", toc);
        if (toc == null) {
            return null;
        }
        return (TOCHandle)toc.getHandle(this.getPropertyHandle("toc"));
    }

    public String getBookmark() {
        return this.getStringProperty("bookmark");
    }

    public void setBookmark(String value) throws SemanticException {
        this.setStringProperty("bookmark", value);
    }

    public String getACLExpression() {
        return this.getStringProperty("ACLExpression");
    }

    public void setACLExpression(String expr) throws SemanticException {
        this.setStringProperty("ACLExpression", expr);
    }

    public boolean cascadeACL() {
        return this.getBooleanProperty("cascadeACL");
    }

    public void setCascadeACL(boolean cascadeACL) throws SemanticException {
        this.setBooleanProperty("cascadeACL", cascadeACL);
    }

    public String getBookmarkDisplayName() {
        return this.getStringProperty("bookmarkDisplayName");
    }

    public void setBookmarkDisplayName(String bookmarkDisplayName) throws SemanticException {
        this.setStringProperty("bookmarkDisplayName", bookmarkDisplayName);
    }

    public boolean showDetailFilter() {
        return this.getBooleanProperty("showDetailFilter");
    }

    public void setShowDetailFilter(boolean showDetailFilter) throws SemanticException {
        this.setBooleanProperty("showDetailFilter", showDetailFilter);
    }
}

