/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencableElement;
import org.eclipse.birt.report.model.metadata.ReferenceValue;

public class ElementRefValue
extends ReferenceValue {
    public ElementRefValue(String namespace, String theName) {
        super(namespace, theName);
    }

    public ElementRefValue(String namespace, DesignElement element) {
        super(namespace, element);
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.resolved != null) {
            return ((DesignElement)this.resolved).getFullName();
        }
        assert (false);
        return null;
    }

    @Override
    public void resolve(Object element) {
        assert (element instanceof DesignElement);
        this.name = null;
        this.resolved = element;
    }

    public DesignElement getElement() {
        return (DesignElement)this.resolved;
    }

    public IReferencableElement getTargetElement() {
        return (IReferencableElement)this.resolved;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ElementRefValue)) {
            return false;
        }
        ElementRefValue value = (ElementRefValue)obj;
        if (this.isResolved() != value.isResolved()) {
            return false;
        }
        if (value.isResolved()) {
            return this.getElement().equals(value.getElement());
        }
        if (!this.getName().equals(value.getName())) {
            return false;
        }
        String myNameSpace = this.getLibraryNamespace();
        String objNameSpace = value.getLibraryNamespace();
        if (myNameSpace == null && objNameSpace == null) {
            return true;
        }
        return myNameSpace != null && myNameSpace.equals(objNameSpace);
    }

    @Override
    public Object copy() {
        return new ElementRefValue(this.getLibraryNamespace(), this.getName());
    }
}

