/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.msw.build.core;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.build.IToolChainProvider;
import org.eclipse.cdt.msw.build.core.MSVCToolChain;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class MSVCToolChainProvider
implements IToolChainProvider {
    public String getId() {
        return "org.eclipse.cdt.msw.build";
    }

    public void init(IToolChainManager manager) throws CoreException {
        Path vsPath = Paths.get("C:", "Program Files (x86)", "Microsoft Visual Studio");
        if (!Files.exists(vsPath, new LinkOption[0])) {
            return;
        }
        Path vs2017Path = vsPath.resolve("2017");
        if (!Files.exists(vs2017Path, new LinkOption[0])) {
            return;
        }
        Path msvcPath = vs2017Path.resolve("BuildTools").resolve("VC").resolve("Tools").resolve("MSVC");
        if (!Files.exists(msvcPath, new LinkOption[0])) {
            return;
        }
        String hostPath = Platform.getOSArch().equals("x86") ? "HostX86" : "HostX64";
        String archPath = Platform.getOSArch().equals("x86") ? "x86" : "x64";
        try {
            Files.find(msvcPath, 6, (path, attr) -> path.getFileName().toString().equalsIgnoreCase("cl.exe") && path.getParent().getParent().getFileName().toString().equalsIgnoreCase(hostPath) && path.getParent().getFileName().toString().equalsIgnoreCase(archPath), new FileVisitOption[0]).forEach(path -> manager.addToolChain((IToolChain)new MSVCToolChain(this, path.getParent())));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "net.sf.wascana.msvc.build", "Finding cl.exe", (Throwable)e));
        }
    }

    public IToolChain getToolChain(String id, String version) throws CoreException {
        return super.getToolChain(id, version);
    }
}

