/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.emf.ui.common.CommandToStringConverter;
import org.eclipse.e4.tools.emf.ui.common.ContributionURIValidator;
import org.eclipse.e4.tools.emf.ui.common.IContributionClassCreator;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.ContributionClassDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.HandlerCommandSelectionDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.objectdata.ObjectViewer;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class HandlerEditor
extends AbstractComponentEditor {
    private Composite composite;
    private EMFDataBindingContext context;
    private StackLayout stackLayout;
    @Inject
    private IModelResource resource;
    @Inject
    @Optional
    private IProject project;
    @Inject
    IEclipseContext eclipseContext;

    @Inject
    public HandlerEditor() {
    }

    @Override
    public Image getImage(Object element) {
        return this.getImage(element, "IMG_org.eclipse.e4.tools.emf.ui.modelelements.Handler");
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.HandlerEditor_Label;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.HandlerEditor_Description;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        Control topControl;
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            if (this.getEditor().isModelFragment()) {
                this.composite = new Composite(parent, 0);
                this.stackLayout = new StackLayout();
                this.composite.setLayout((Layout)this.stackLayout);
                this.createForm(this.composite, this.context, (IObservableValue)this.getMaster(), false);
                this.createForm(this.composite, this.context, (IObservableValue)this.getMaster(), true);
            } else {
                this.composite = this.createForm(parent, this.context, (IObservableValue)this.getMaster(), false);
            }
        }
        if (this.getEditor().isModelFragment() && this.stackLayout.topControl != (topControl = Util.isImport((EObject)object) ? this.composite.getChildren()[1] : this.composite.getChildren()[0])) {
            this.stackLayout.topControl = topControl;
            this.composite.layout(true, true);
        }
        this.getMaster().setValue(object);
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, IObservableValue master, boolean isImport) {
        Link lnk;
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        if (isImport) {
            ControlFactory.createFindImport(parent, this.Messages, this, context);
            folder.setSelection(0);
            return folder;
        }
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_Common_Id, master, context, textProp, EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__ELEMENT_ID));
        Label l = new Label(parent, 0);
        l.setText(this.Messages.HandlerEditor_Command);
        l.setLayoutData((Object)new GridData(128));
        Text t = new Text(parent, 2048);
        ControlFactory.TextPasteHandler.createFor(t);
        t.setLayoutData((Object)new GridData(768));
        t.setEditable(false);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)CommandsPackageImpl.Literals.HANDLER__COMMAND).observeDetail((IObservableValue)this.getMaster()), new UpdateValueStrategy(), new UpdateValueStrategy().setConverter((IConverter)new CommandToStringConverter(this.Messages)));
        final Button b = new Button(parent, 0x800008);
        b.setText(this.Messages.ModelTooling_Common_FindEllipsis);
        b.setImage(this.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.zoom"));
        b.setLayoutData((Object)new GridData(4, 2, false, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HandlerCommandSelectionDialog dialog = new HandlerCommandSelectionDialog(b.getShell(), (MHandler)HandlerEditor.this.getMaster().getValue(), HandlerEditor.this.resource, HandlerEditor.this.Messages);
                dialog.open();
            }
        });
        final IContributionClassCreator c = this.getEditor().getContributionCreator(CommandsPackageImpl.Literals.HANDLER);
        if (this.project != null && c != null) {
            lnk = new Link(parent, 0);
            lnk.setText("<A>" + this.Messages.HandlerEditor_ClassURI + "</A>");
            lnk.setLayoutData((Object)new GridData(128));
            lnk.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    c.createOpen((MContribution)HandlerEditor.this.getMaster().getValue(), HandlerEditor.this.getEditingDomain(), HandlerEditor.this.project, lnk.getShell());
                }
            });
        } else {
            lnk = null;
            Label l2 = new Label(parent, 0);
            l2.setText(this.Messages.HandlerEditor_ClassURI);
            l2.setLayoutData((Object)new GridData(128));
        }
        Text t2 = new Text(parent, 2048);
        ControlFactory.TextPasteHandler.createFor(t2);
        t2.setLayoutData((Object)new GridData(768));
        t2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (lnk != null) {
                    lnk.setToolTipText(((Text)e.getSource()).getText());
                }
            }
        });
        Binding binding = context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t2), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)ApplicationPackageImpl.Literals.CONTRIBUTION__CONTRIBUTION_URI).observeDetail((IObservableValue)this.getMaster()), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new ContributionURIValidator()), new UpdateValueStrategy());
        Util.addDecoration((Control)t2, binding);
        final Button b2 = new Button(parent, 0x800008);
        b2.setImage(this.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.zoom"));
        b2.setText(this.Messages.ModelTooling_Common_FindEllipsis);
        b2.setLayoutData((Object)new GridData(4, 2, false, false));
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContributionClassDialog dialog = new ContributionClassDialog(b2.getShell(), HandlerEditor.this.eclipseContext, HandlerEditor.this.getEditingDomain(), (MApplicationElement)((MContribution)HandlerEditor.this.getMaster().getValue()), (EStructuralFeature)ApplicationPackageImpl.Literals.CONTRIBUTION__CONTRIBUTION_URI, HandlerEditor.this.Messages);
                dialog.open();
            }
        });
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Contribution_PersistedState, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__PERSISTED_STATE, 10);
        item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabSupplementary);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.CategoryEditor_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Contribution_PersistedState, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__PERSISTED_STATE, 10);
        this.createInstanceInspection(folder);
        this.createContributedEditorTabs(folder, context, this.getMaster(), MHandler.class);
        folder.setSelection(0);
        return folder;
    }

    private void createInstanceInspection(CTabFolder folder) {
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_RuntimeContributionInstance);
        Composite container = new Composite((Composite)folder, 0);
        container.setLayout((Layout)new GridLayout());
        item.setControl((Control)container);
        ObjectViewer objectViewer = new ObjectViewer();
        TreeViewer viewer = objectViewer.createViewer(container, (EStructuralFeature)ApplicationPackageImpl.Literals.CONTRIBUTION__OBJECT, (IObservableValue)this.getMaster(), this.resourcePool, this.Messages);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
    }

    @Override
    public IObservableList getChildList(Object element) {
        return null;
    }

    @Override
    public String getDetailLabel(Object element) {
        MHandler handler = (MHandler)element;
        if (handler.getCommand() != null && handler.getCommand().getCommandName() != null && handler.getCommand().getCommandName().trim().length() > 0) {
            return handler.getCommand().getCommandName();
        }
        return null;
    }

    @Override
    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[]{FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{CommandsPackageImpl.Literals.HANDLER__COMMAND, CommandsPackageImpl.Literals.COMMAND__COMMAND_NAME})};
    }
}

