/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.handler;

import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.copy.command.CopyDataCommandHandler;
import net.sourceforge.nattable.copy.command.CopyDataToClipboardCommand;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.selection.SelectionLayer;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IGridElement;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.NatTableWidget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class CopyToClipboardCommandHandler
extends CopyDataCommandHandler {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final NatTableWidget widget;
    private final SelectionLayer selectionLayer;

    public CopyToClipboardCommandHandler(SelectionLayer selectionLayer, NatTableWidget widget) {
        super(selectionLayer);
        this.selectionLayer = selectionLayer;
        this.widget = widget;
    }

    public boolean doCommand(CopyDataToClipboardCommand command) {
        LayerCell[][] copiedCells = this.assembleCopiedDataStructure();
        this.serializeToClipboard(command, copiedCells);
        return true;
    }

    private void serializeToClipboard(CopyDataToClipboardCommand command, LayerCell[][] copiedCells) {
        String textData = this.createTextData(command, copiedCells);
        ISelection localData = this.createLocalData();
        if (textData.length() > 0 || !localData.isEmpty()) {
            Object[] data = new Object[]{textData, localData};
            Transfer[] dataTypes = new Transfer[]{TextTransfer.getInstance(), LocalTransfer.getInstance()};
            Clipboard clipboard = command.getClipboard();
            clipboard.setContents(data, dataTypes);
        }
    }

    protected String createTextData(CopyDataToClipboardCommand command, LayerCell[][] copiedCells) {
        String result;
        try {
            result = this.getContigusCellText(command, copiedCells);
        }
        catch (Exception exception) {
            result = this.getNonContigusCellText();
        }
        return result;
    }

    protected String getContigusCellText(CopyDataToClipboardCommand command, LayerCell[][] copiedCells) {
        String cellDelimeter = command.getCellDelimeter();
        StringBuilder textData = new StringBuilder();
        int currentRow = 0;
        LayerCell[][] layerCellArray = copiedCells;
        int n = copiedCells.length;
        int n2 = 0;
        while (n2 < n) {
            LayerCell[] cells = layerCellArray[n2];
            if (currentRow == 0) {
                String header = this.createHeaderText(cellDelimeter, cells);
                textData.append(header);
            }
            boolean first = true;
            LayerCell[] layerCellArray2 = cells;
            int n3 = cells.length;
            int n4 = 0;
            while (n4 < n3) {
                LayerCell cell = layerCellArray2[n4];
                if (first) {
                    first = false;
                } else {
                    textData.append(cellDelimeter);
                }
                if (cell != null) {
                    textData.append(this.createCellText(cell));
                }
                ++n4;
            }
            if (++currentRow < copiedCells.length) {
                textData.append(NEW_LINE);
            }
            ++n2;
        }
        return textData.toString();
    }

    protected String getNonContigusCellText() {
        PositionCoordinate[] selectedCells;
        StringBuilder result = new StringBuilder();
        PositionCoordinate[] positionCoordinateArray = selectedCells = this.selectionLayer.getSelectedCells();
        int n = selectedCells.length;
        int n2 = 0;
        while (n2 < n) {
            PositionCoordinate positionCoordinate = positionCoordinateArray[n2];
            int columnPosition = positionCoordinate.getColumnPosition();
            int rowPosition = positionCoordinate.getRowPosition();
            Table table = this.widget.getController().getTable();
            Row row = (Row)table.getRows().get(rowPosition);
            Column column = (Column)table.getColumns().get(columnPosition);
            if (column instanceof FeatureColumn) {
                FeatureColumn featureColumn = (FeatureColumn)column;
                ETypedElement feature = featureColumn.getFeature();
                String valueStr = this.getCellValueStr(row, feature);
                result.append((Object)valueStr);
                result.append(NEW_LINE);
            }
            ++n2;
        }
        return result.toString();
    }

    protected String getCellValueStr(Row row, ETypedElement feature) {
        String result;
        try {
            Object value = this.getCellValue(feature, row.getElement());
            result = this.getLabelProvider().getText(value);
        }
        catch (FacetManagerException e1) {
            result = "!!! ERRORR, cf. log !!!";
            Logger.logError((Throwable)e1, (Plugin)Activator.getDefault());
        }
        return result;
    }

    protected String createCellText(LayerCell cell) {
        String result = "";
        Object dataValue = cell.getDataValue();
        if (dataValue instanceof IGridElement) {
            IGridElement gridElement = (IGridElement)dataValue;
            ETypedElement columnFeature = ((FeatureColumn)gridElement.getColumn()).getFeature();
            Row row = gridElement.getRow();
            result = this.getCellValueStr(row, columnFeature);
        }
        return result;
    }

    protected Object getCellValue(ETypedElement columnFeature, EObject element) throws FacetManagerException {
        ITableWidgetInternal controller = this.widget.getController();
        IFacetManager facetContext = controller.getFacetContext();
        return facetContext.getOrInvoke(element, columnFeature, Object.class);
    }

    protected ICustomizedLabelProvider getLabelProvider() {
        ITableWidgetInternal controller = this.widget.getController();
        return controller.getTableLabelProvider();
    }

    protected String createHeaderText(String cellDelimeter, LayerCell[] cells) {
        StringBuilder result = new StringBuilder();
        String[] columnNames = this.widget.getColumnNames();
        boolean first = true;
        LayerCell[] layerCellArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            LayerCell cell = layerCellArray[n2];
            if (first) {
                first = false;
            } else {
                result.append(cellDelimeter);
            }
            int originColumnPosition = cell.getOriginColumnPosition();
            int converted = this.widget.convertColumnPositionSelectionToData(originColumnPosition);
            result.append(columnNames[converted]);
            ++n2;
        }
        result.append(NEW_LINE);
        return result.toString();
    }

    private ISelection createLocalData() {
        ITableWidgetInternal controller = this.widget.getController();
        return controller.getSelection();
    }
}

