/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget.utils;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.osgi.framework.Bundle;

public final class ResourceUtils {
    private static final String TMP_FILE_NAME = String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + ".tmp.table";
    private static final File DEFAULT_RSRC_FILE = new File(Platform.getStateLocation((Bundle)Activator.getDefault().getBundle()).toOSString(), TMP_FILE_NAME);

    private ResourceUtils() {
    }

    public static Resource createDefaultResource(EditingDomain editingDomain) {
        ResourceSet resourceSet = editingDomain.getResourceSet();
        String resourcePath = DEFAULT_RSRC_FILE.getPath();
        URI uri = URI.createFileURI((String)resourcePath);
        return resourceSet.createResource(uri);
    }

    public static String getStringURI(EObject eObject) {
        URI uri = EcoreUtil.getURI((EObject)eObject);
        return uri.toString();
    }

    public static boolean usesTmpResource(EObject eObject) {
        Resource resource = eObject.eResource();
        String uri = URI.createFileURI((String)DEFAULT_RSRC_FILE.toString()).toFileString();
        String resourceURI = resource.getURI().toFileString();
        return uri.equals(resourceURI);
    }

    public static boolean isTmpResource(Resource resource) {
        URI uri = resource.getURI();
        return uri.lastSegment().equals(TMP_FILE_NAME);
    }
}

