/**
 * Copyright (c) 2013 RCP Vision (http://www.rcp-vision.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Lorenzo Bettini - initial API and implementation
 */
package org.eclipse.emf.parsley.dsl.ui.outline;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.parsley.dsl.model.BindingsSpecification;
import org.eclipse.emf.parsley.dsl.model.Model;
import org.eclipse.emf.parsley.dsl.model.Module;
import org.eclipse.emf.parsley.dsl.model.PartsSpecifications;
import org.eclipse.emf.parsley.dsl.model.WithExtendsClause;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Customization of the default outline structure.
 * 
 * see http://www.eclipse.org/Xtext/documentation.html#outline
 */
@SuppressWarnings("all")
public class EmfParsleyDslOutlineTreeProvider extends DefaultOutlineTreeProvider {
  protected void _createChildren(final DocumentRootNode parentNode, final Model m) {
    this.createChildren(parentNode, m.getModule());
  }
  
  protected void _createChildren(final IOutlineNode parentNode, final Module m) {
    final Function1<EObject, Integer> _function = new Function1<EObject, Integer>() {
      @Override
      public Integer apply(final EObject it) {
        return Integer.valueOf(NodeModelUtils.getNode(it).getOffset());
      }
    };
    final List<EObject> contentsOrderedByOffset = IterableExtensions.<EObject, Integer>sortBy(m.eContents(), _function);
    for (final EObject o : contentsOrderedByOffset) {
      this.createNode(parentNode, o);
    }
  }
  
  public boolean _isLeaf(final Module m) {
    return false;
  }
  
  public boolean _isLeaf(final BindingsSpecification e) {
    return true;
  }
  
  public boolean _isLeaf(final PartsSpecifications e) {
    return true;
  }
  
  public boolean _isLeaf(final WithExtendsClause e) {
    return true;
  }
}
