/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.sections;

import java.util.HashMap;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldApplyListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.LayoutUtil;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.RadiosDialogField;
import org.eclipse.jst.pagedesigner.commands.single.ChangeTagCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.sections.SectionResources;
import org.eclipse.jst.pagedesigner.properties.BaseCustomSection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;

public class JSFHtmlInputTextTypeSection
extends BaseCustomSection {
    private RadiosDialogField _typesField = new RadiosDialogField();
    private static final String[] TYPES = new String[]{SectionResources.getString("JSFHtmlInputHiddenSection.Type0"), SectionResources.getString("JSFHtmlInputHiddenSection.Type1"), SectionResources.getString("JSFHtmlInputHiddenSection.Type2"), SectionResources.getString("JSFHtmlInputHiddenSection.Type3")};

    public JSFHtmlInputTextTypeSection() {
        this._typesField.setLabelText(SectionResources.getString("JSFHtmlInputHiddenSection.Type"));
        this._typesField.setItems(TYPES);
        this._typesField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String size;
                int type = JSFHtmlInputTextTypeSection.this._typesField.getSelectedIndex();
                String prefix = JSFHtmlInputTextTypeSection.this._element.getPrefix();
                String localTag = JSFHtmlInputTextTypeSection.this.toLocalTag(type);
                String newtag = String.valueOf(prefix) + ":" + localTag;
                HashMap<String, String> attrs = new HashMap<String, String>();
                if (type == 3) {
                    size = JSFHtmlInputTextTypeSection.this._element.getAttribute("size");
                    if (size != null && size.length() != 0) {
                        attrs.put("size", null);
                        attrs.put("cols", size);
                    }
                } else {
                    size = JSFHtmlInputTextTypeSection.this._element.getAttribute("cols");
                    if (size != null && size.length() != 0) {
                        attrs.put("cols", null);
                        attrs.put("size", size);
                    }
                }
                ChangeTagCommand c = new ChangeTagCommand(SectionResources.getString("JSFHtmlInputHidden.CommandLabel.ChangeType"), JSFHtmlInputTextTypeSection.this._element, newtag, attrs, true);
                c.execute();
                JSFHtmlInputTextTypeSection.this._element = c.getNewElement();
            }
        });
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = aTabbedPropertySheetPage.getWidgetFactory();
        Composite top = factory.createFlatFormComposite(parent);
        int numberOfColumns = this._typesField.getNumberOfControls();
        GridLayout layout = new GridLayout(numberOfColumns, false);
        top.setLayout((Layout)layout);
        this._typesField.doFillIntoGrid((FormToolkit)factory, top, numberOfColumns);
        LayoutUtil.setGrabHorizontal((Control)this._typesField.getGroup((FormToolkit)factory, top), (boolean)true);
    }

    private String toLocalTag(int type) {
        switch (type) {
            case 1: {
                return "inputSecret";
            }
            case 0: {
                return "inputHidden";
            }
            case 3: {
                return "inputTextarea";
            }
            case 2: {
                return "inputText";
            }
        }
        return "inputHidden";
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this._typesField.setSelectedIndexWithoutUpdate(this.getInputType());
    }

    public int getInputType() {
        String localTag = this._element.getLocalName();
        if ("inputText".equals(localTag)) {
            return 2;
        }
        if ("inputSecret".equals(localTag)) {
            return 1;
        }
        if ("inputHidden".equals(localTag)) {
            return 0;
        }
        if ("inputTextarea".equals(localTag)) {
            return 3;
        }
        return 0;
    }

    protected void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (this._typesField != null) {
            this._typesField.setSelectedIndexWithoutUpdate(this.getInputType());
        }
    }
}

