/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.wizards.template;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jwt.meta.model.core.CorePackage;
import org.eclipse.jwt.meta.model.core.Model;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.meta.model.processes.ProcessesPackage;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.commands.template.ImportTemplateCommand;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.misc.wizards.template.exp.ExportTemplateWizardPage;
import org.eclipse.jwt.we.misc.wizards.template.imp.ImportTemplateWizardPage;
import org.eclipse.jwt.we.misc.wizards.template.select.ModeTemplateWizardPage;
import org.eclipse.jwt.we.model.view.Diagram;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class TemplateWizard
extends Wizard
implements INewWizard {
    static final Logger logger = Logger.getLogger(TemplateWizard.class);
    protected ModeTemplateWizardPage modePage;
    protected ExportTemplateWizardPage exportPage;
    protected ImportTemplateWizardPage importPage;
    protected IWorkbench workbench;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.setWindowTitle(PluginProperties.wizards_TemplateWizard_title);
        this.setDefaultPageImageDescriptor(Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createImageDescriptor(PluginProperties.editor_Wizard_icon));
    }

    public void addPages() {
        this.modePage = new ModeTemplateWizardPage("mode", this.workbench);
        this.modePage.setTitle(PluginProperties.wizards_ModeTemplateWizard_title);
        this.addPage((IWizardPage)this.modePage);
        this.importPage = new ImportTemplateWizardPage("import", this.workbench);
        this.importPage.setTitle(PluginProperties.wizards_ImportTemplateWizard_title);
        this.importPage.setDescription(PluginProperties.wizards_ImportSelect_label);
        this.addPage((IWizardPage)this.importPage);
        this.exportPage = new ExportTemplateWizardPage("export", this.workbench);
        this.exportPage.setTitle(PluginProperties.wizards_ExportTemplateWizard_title);
        this.exportPage.setDescription(PluginProperties.wizards_ExportSelect_label);
        this.addPage((IWizardPage)this.exportPage);
    }

    public boolean canFinish() {
        if (this.modePage.isImportMode()) {
            return ((ImportTemplateWizardPage)this.getPage("import")).validatePage();
        }
        return ((ExportTemplateWizardPage)this.getPage("export")).validatePage();
    }

    public boolean performFinish() {
        if (this.modePage.isImportMode()) {
            return this.performFinishImport();
        }
        return this.performFinishExport();
    }

    public boolean performFinishImport() {
        boolean successful = true;
        ArrayList templates = ((ImportTemplateWizardPage)this.getPage("import")).getTemplates();
        try {
            if (templates.size() != 0) {
                Iterator i = templates.iterator();
                while (i.hasNext()) {
                    URI fileUri = URI.createFileURI((String)((String)i.next()));
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(WEEditor.getTemplateExtension(), new XMIResourceFactoryImpl());
                    resourceSet.getPackageRegistry().put((Object)"org.eclipse.jwt/core", (Object)CorePackage.eINSTANCE);
                    resourceSet.getPackageRegistry().put((Object)"org.eclipse.jwt/processes", (Object)ProcessesPackage.eINSTANCE);
                    try {
                        Model importModel = null;
                        Diagram importDiagram = null;
                        for (Object object : resourceSet.getResource(fileUri, true).getContents()) {
                            if (object instanceof Model) {
                                importModel = (Model)object;
                                continue;
                            }
                            if (!(object instanceof Diagram)) continue;
                            importDiagram = (Diagram)object;
                        }
                        Model rootPackage = (Model)GeneralHelper.getActiveInstance().getModel();
                        Diagram rootDiagram = GeneralHelper.getActiveInstance().getDiagramData();
                        GeneralHelper.getActiveInstance().getEditDomain().getCommandStack().execute((Command)new ImportTemplateCommand((Package)rootPackage, rootDiagram, (Package)importModel, importDiagram));
                    }
                    catch (Exception e) {
                        logger.warning("Error importing file `" + fileUri.toFileString() + "'.", e);
                        successful = false;
                    }
                }
            }
        }
        catch (Exception exception) {
            successful = false;
        }
        this.finishMessageImport(successful);
        return successful;
    }

    public boolean performFinishExport() {
        URI fileUri;
        block4: {
            String filename = "";
            try {
                filename = this.exportPage.getFileURI().toFileString();
                if (!filename.endsWith(WEEditor.getTemplateExtension())) {
                    filename = String.valueOf(filename) + "." + WEEditor.getTemplateExtension();
                }
                File newfile = new File(filename);
                fileUri = URI.createFileURI((String)filename);
                if (!newfile.exists() || MessageDialog.openQuestion((Shell)this.getShell(), (String)PluginProperties.editor_QuestionOverwriteFile_title, (String)PluginProperties.editor_QuestionOverwriteFile_message(newfile.getAbsolutePath()))) break block4;
                this.exportPage.selectFileField();
                return false;
            }
            catch (Exception exception) {
                logger.warning(exception);
                this.finishMessageExport(filename, false);
                return false;
            }
        }
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor progressMonitor) {
                try {
                    Resource resource = new ResourceSetImpl().createResource(fileUri);
                    Collection<EObject> modelElements = TemplateWizard.this.exportPage.getResources();
                    if (modelElements == null) {
                        TemplateWizard.this.finishMessageExport(fileUri.toFileString(), false);
                        return;
                    }
                    try {
                        for (EObject object : modelElements) {
                            if (!(object instanceof Model) && !(object instanceof Diagram)) continue;
                            resource.getContents().add((Object)object);
                        }
                        HashMap<String, String> options = new HashMap<String, String>();
                        options.put("ENCODING", "UTF-8");
                        resource.save(options);
                        modelElements.clear();
                        TemplateWizard.this.finishMessageExport(fileUri.toFileString(), true);
                    }
                    catch (Exception exception) {
                        logger.warning(exception);
                        TemplateWizard.this.finishMessageExport(fileUri.toFileString(), false);
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        this.getContainer().run(false, false, operation);
        return true;
    }

    public void finishMessageImport(boolean successful) {
        if (successful) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)PluginProperties.wizards_Import_title, (String)PluginProperties.wizards_Import_ok);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)PluginProperties.wizards_Import_title, (String)PluginProperties.wizards_Import_failed);
        }
    }

    public void finishMessageExport(String filename, boolean successful) {
        if (successful) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)PluginProperties.wizards_Export_title, (String)PluginProperties.bind((String)PluginProperties.wizards_Export_ok, (Object)filename));
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)PluginProperties.wizards_Export_title, (String)PluginProperties.bind((String)PluginProperties.wizards_Export_failed, (Object)filename));
        }
    }
}

