/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.debug.core.internal.interpreter.generic;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.debug.DbgpConnectionConfig;
import org.eclipse.ldt.debug.core.internal.Activator;
import org.eclipse.ldt.debug.core.internal.interpreter.generic.LuaGenericInterpreterConfigurer;

public class LuaGenericDebuggingEngineConfigurer
extends LuaGenericInterpreterConfigurer {
    private InterpreterConfig initialConfig;

    @Override
    public InterpreterConfig alterConfig(ILaunch launch, InterpreterConfig config, IInterpreterInstall interpreterinstall) throws CoreException {
        this.initialConfig = config;
        InterpreterConfig interpreterConfig = (InterpreterConfig)config.clone();
        return super.alterConfig(launch, interpreterConfig, interpreterinstall);
    }

    @Override
    protected List<IPath> getLuaPath(ILaunch launch, InterpreterConfig config) throws CoreException {
        List<IPath> luaPath = super.getLuaPath(launch, config);
        try {
            URL debuggerEntry = Activator.getDefault().getBundle().getEntry("script/external");
            File debuggerFolder = new File(FileLocator.toFileURL((URL)debuggerEntry).getFile());
            luaPath.add((IPath)new Path(debuggerFolder.getPath()));
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ldt.debug.core", "Unable to extract debugger files."));
        }
        return luaPath;
    }

    @Override
    protected List<String> addCommands(ILaunch launch, InterpreterConfig config) throws CoreException {
        List<String> parentList = super.addCommands(launch, config);
        parentList.add(this.createRunDebuggerCommand(launch, config));
        return parentList;
    }

    @Override
    protected Map<String, String> addEnvironmentVariables(ILaunch launch, InterpreterConfig config) throws CoreException {
        String os;
        Map<String, String> envVars = super.addEnvironmentVariables(launch, config);
        DbgpConnectionConfig dbgpConnectionConfig = DbgpConnectionConfig.load((InterpreterConfig)this.initialConfig);
        envVars.put("DBGP_IDEHOST", "127.0.0.1");
        int port = dbgpConnectionConfig.getPort();
        envVars.put("DBGP_IDEPORT", Integer.toString(port));
        String sessionId = dbgpConnectionConfig.getSessionId();
        envVars.put("DBGP_IDEKEY", sessionId);
        String transportLayer = this.getTransportLayer();
        if (transportLayer != null && config.getEnvVar("DBGP_TRANSPORT") == null) {
            envVars.put("DBGP_TRANSPORT", transportLayer);
        }
        if ((os = Platform.getOS()).equals("win32")) {
            envVars.put("DBGP_PLATFORM", "win");
        } else {
            envVars.put("DBGP_PLATFORM", "unix");
        }
        IPath workingDirectory = config.getWorkingDirectoryPath();
        if (!workingDirectory.isEmpty()) {
            envVars.put("DBGP_WORKINGDIR", workingDirectory.toPortableString());
        }
        envVars.put("DEBUG_MODE", "true");
        return envVars;
    }

    protected String createRunDebuggerCommand(ILaunch launch, InterpreterConfig config) {
        return "require ('debugger')();";
    }

    protected String getTransportLayer() {
        return null;
    }
}

