/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.ui.container;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.net4j.internal.ui.bundle.OM;
import org.eclipse.net4j.jvm.IJVMAcceptor;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.ui.container.ElementWizard;
import org.eclipse.net4j.util.ui.container.ElementWizardFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class JVMConnectorWizard
extends ElementWizard {
    protected void create(Composite parent) {
        String description;
        ArrayList<String> choices = new ArrayList<String>();
        try {
            Object[] elements;
            Object[] objectArray = elements = this.getContainer().getElements("org.eclipse.net4j.acceptors", "jvm");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IJVMAcceptor) {
                    IJVMAcceptor acceptor = (IJVMAcceptor)object;
                    choices.add(acceptor.getName());
                }
                ++n2;
            }
        }
        catch (NoClassDefFoundError error) {
            OM.LOG.error((Throwable)error);
        }
        if (!choices.isEmpty()) {
            Collections.sort(choices);
            final Combo acceptorCombo = JVMConnectorWizard.addCombo((Composite)parent, (String)"Acceptor:", choices);
            acceptorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String acceptorName = acceptorCombo.getText();
                    JVMConnectorWizard.this.setResultDescription(acceptorName);
                }
            });
            description = this.getDefaultDescription();
            if (description != null) {
                acceptorCombo.setText(description);
            }
        } else {
            final Text acceptorNameText = JVMConnectorWizard.addText((Composite)parent, (String)"Acceptor Name:");
            acceptorNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String acceptorName = acceptorNameText.getText();
                    if (acceptorName.length() == 0) {
                        JVMConnectorWizard.this.setValidationError(acceptorNameText, "Acceptor name is empty.");
                        return;
                    }
                    JVMConnectorWizard.this.setResultDescription(acceptorName);
                    JVMConnectorWizard.this.setValidationError(acceptorNameText, null);
                }
            });
            description = this.getDefaultDescription();
            if (description != null) {
                acceptorNameText.setText(description);
            }
        }
    }

    public static class Factory
    extends ElementWizardFactory {
        public Factory() {
            super("org.eclipse.net4j.connectors", "jvm");
        }

        public JVMConnectorWizard create(String description) throws ProductCreationException {
            return new JVMConnectorWizard();
        }
    }
}

