/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import org.eclipse.net4j.signal.ISignalProtocol;
import org.eclipse.net4j.signal.Signal;
import org.eclipse.net4j.signal.SignalFinishedEvent;
import org.eclipse.net4j.util.collection.HashBag;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SignalCounter
implements IListener {
    private HashBag<Class<? extends Signal>> signals = new HashBag();
    private final ISignalProtocol<?> protocol;

    public SignalCounter() {
        this.protocol = null;
    }

    public SignalCounter(ISignalProtocol<?> protocol) {
        this.protocol = protocol;
        if (protocol != null) {
            protocol.addListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountForSignalTypes() {
        HashBag<Class<? extends Signal>> hashBag = this.signals;
        synchronized (hashBag) {
            return this.signals.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountFor(Class<? extends Signal> signal) {
        HashBag<Class<? extends Signal>> hashBag = this.signals;
        synchronized (hashBag) {
            return this.signals.getCounterFor(signal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeCountFor(Class<? extends Signal> signal) {
        HashBag<Class<? extends Signal>> hashBag = this.signals;
        synchronized (hashBag) {
            return this.signals.removeCounterFor(signal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCounts() {
        HashBag<Class<? extends Signal>> hashBag = this.signals;
        synchronized (hashBag) {
            this.signals.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvent(IEvent event) {
        if (event instanceof SignalFinishedEvent) {
            HashBag<Class<? extends Signal>> hashBag = this.signals;
            synchronized (hashBag) {
                SignalFinishedEvent e = (SignalFinishedEvent)event;
                this.signals.add(e.getSignal().getClass());
            }
        }
    }

    public void dispose() {
        if (this.protocol != null) {
            this.protocol.removeListener(this);
        }
    }
}

