/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.commands;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.uml.decoratormodel.internal.providers.DecoratorPackageCache;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.messages.Messages;
import org.eclipse.papyrus.uml.tools.utils.CustomUMLUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Package;

public class UnloadDecoratorModelHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getActiveMenuSelectionChecked((ExecutionEvent)event);
        ResourceSet resourceSet = null;
        HashSet toUnload = Sets.newHashSet();
        if (selection instanceof IStructuredSelection) {
            for (Object next : ((IStructuredSelection)selection).toList()) {
                EObject eObject = EMFHelper.getEObject(next);
                if (!(eObject instanceof Package)) continue;
                Resource resource = eObject.eResource();
                toUnload.add(resource);
                resourceSet = resource.getResourceSet();
            }
        }
        if (resourceSet != null) {
            UnloadDecoratorModelHandler.unloadResources(window, resourceSet, toUnload);
        }
        return null;
    }

    public static void unloadResources(IWorkbenchWindow uiContext, ResourceSet resourceSet, final Iterable<? extends Resource> resources) throws ExecutionException {
        TransactionalEditingDomain domain;
        final SaveHandler save = UnloadDecoratorModelHandler.getSaveHandler(resourceSet);
        boolean needSave = save.isSaveNeeded(resources);
        if (needSave) {
            if (!UnloadDecoratorModelHandler.confirmSave(uiContext.getShell())) {
                return;
            }
            try {
                uiContext.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        try {
                            save.save(resources, monitor);
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                throw new ExecutionException(Messages.UnloadDecoratorModelHandler_0, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ExecutionException(Messages.UnloadDecoratorModelHandler_1, e.getTargetException());
            }
        }
        if ((domain = TransactionUtil.getEditingDomain((ResourceSet)resourceSet)) != null) {
            class UnloadCommand
            extends AbstractCommand
            implements AbstractCommand.NonDirtying {
                private final /* synthetic */ Iterable val$resources;

                UnloadCommand(Iterable iterable) {
                    this.val$resources = iterable;
                    super(Messages.UnloadDecoratorModelHandler_2);
                }

                protected boolean prepare() {
                    return true;
                }

                public void execute() {
                    for (Resource next : this.val$resources) {
                        DecoratorPackageCache.aboutToUnload((Resource)next);
                        CustomUMLUtil.destroyAll((Collection)next.getContents());
                        next.unload();
                        next.getResourceSet().getResources().remove((Object)next);
                        next.eAdapters().clear();
                    }
                }

                public boolean canUndo() {
                    return false;
                }

                public void redo() {
                    throw new IllegalStateException("command was not undone");
                }
            }
            domain.getCommandStack().execute((Command)new UnloadCommand(resources));
        }
    }

    static SaveHandler getSaveHandler(ResourceSet resourceSet) {
        return resourceSet instanceof ModelSet ? new ModelSetSaveHandlerImpl((ModelSet)resourceSet) : new SaveHandlerImpl(resourceSet);
    }

    static boolean confirmSave(Shell parentShell) {
        return MessageDialog.openConfirm((Shell)parentShell, (String)Messages.UnloadDecoratorModelHandler_2, (String)Messages.UnloadDecoratorModelHandler_3);
    }

    static class ModelSetSaveHandlerImpl
    implements SaveHandler {
        private final ModelSet modelSet;

        ModelSetSaveHandlerImpl(ModelSet modelSet) {
            this.modelSet = modelSet;
        }

        @Override
        public boolean isSaveNeeded(Iterable<? extends Resource> resources) {
            boolean result = false;
            for (Resource resource : resources) {
                if (!this.modelSet.shouldSave(resource)) continue;
                result = true;
                break;
            }
            return result;
        }

        @Override
        public void save(Iterable<? extends Resource> resources, IProgressMonitor monitor) throws IOException {
            IMultiDiagramEditor editor = null;
            try {
                editor = (IMultiDiagramEditor)ServiceUtilsForResourceSet.getInstance().getService(IMultiDiagramEditor.class, (Object)this.modelSet);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            if (editor != null) {
                editor.doSave(monitor);
            } else {
                this.modelSet.save(monitor);
            }
        }
    }

    static interface SaveHandler {
        public boolean isSaveNeeded(Iterable<? extends Resource> var1);

        public void save(Iterable<? extends Resource> var1, IProgressMonitor var2) throws IOException;
    }

    static class SaveHandlerImpl
    implements SaveHandler {
        private final ResourceSet resourceSet;

        SaveHandlerImpl(ResourceSet resourceSet) {
            this.resourceSet = resourceSet;
        }

        @Override
        public boolean isSaveNeeded(Iterable<? extends Resource> resources) {
            boolean result = false;
            boolean trackingModification = true;
            for (Resource resource : resources) {
                if (!resource.isTrackingModification()) {
                    result = false;
                    trackingModification = false;
                    break;
                }
                if (!resource.isModified()) continue;
                result = true;
                break;
            }
            if (!result && !trackingModification) {
                EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)this.resourceSet);
                result = editingDomain != null && editingDomain.getCommandStack() instanceof BasicCommandStack ? ((BasicCommandStack)editingDomain.getCommandStack()).isSaveNeeded() : true;
            }
            return result;
        }

        @Override
        public void save(Iterable<? extends Resource> resources, IProgressMonitor monitor) throws IOException {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.UnloadDecoratorModelHandler_4, (int)Iterables.size(resources));
            for (Resource resource : resources) {
                resource.save(null);
                sub.worked(1);
            }
            sub.done();
        }
    }
}

