/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.use;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.use.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PatternSelectionPage
extends WizardPage {
    static final String PAGE_NAME = "select";
    final PatternElement[] fgelements = new PatternElement[]{new PatternElement(Messages.PatternSelectionPage_package_pattern, Messages.PatternSelectionPage_package_pattern_desc, null, "description"), new PatternElement(Messages.PatternSelectionPage_archive_pattern, Messages.PatternSelectionPage_archive_pattern_desc, null, "archive"), new PatternElement(Messages.PatternSelectionPage_report_conversion_pattern, Messages.PatternSelectionPage_report_conversion_pattern_desc, null, "report")};
    TableViewer viewer = null;
    Text description = null;

    protected PatternSelectionPage() {
        super(PAGE_NAME, Messages.PatternSelectionPage_select_pattern, null);
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 2, 1808);
        SWTFactory.createWrapLabel(comp, Messages.PatternSelectionPage_pattern_types, 1);
        this.viewer = new TableViewer(new Table(comp, 67588));
        this.viewer.setLabelProvider((IBaseLabelProvider)new LP());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput((Object)this.fgelements);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String desc = PatternSelectionPage.this.getSelectedElement().desc;
                PatternSelectionPage.this.description.setText(desc == null ? Messages.PatternSelectionPage_no_desc : desc);
                PatternSelectionPage.this.setPageComplete(PatternSelectionPage.this.isPageComplete());
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((PatternElement)e1).name.compareTo(((PatternElement)e2).name);
            }
        });
        GridData gd = new GridData(768);
        gd.heightHint = 100;
        this.viewer.getTable().setLayoutData((Object)gd);
        SWTFactory.createHorizontalSpacer(comp, 1);
        SWTFactory.createWrapLabel(comp, Messages.PatternSelectionPage_description, 1);
        this.description = new Text(comp, 2120);
        this.description.setEnabled(false);
        gd = new GridData(768);
        gd.heightHint = 50;
        this.description.setLayoutData((Object)gd);
        if (this.fgelements != null && this.fgelements.length > 0) {
            this.viewer.setSelection((ISelection)new StructuredSelection(this.viewer.getElementAt(0)), true);
        }
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IApiToolsHelpContextIds.APITOOLS_PATTERN_SELECTION_WIZARD_PAGE);
    }

    public boolean isPageComplete() {
        if (this.viewer.getSelection().isEmpty()) {
            this.setErrorMessage(Messages.PatternSelectionPage_must_select_type);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(Messages.PatternSelectionPage_select_type);
        return true;
    }

    PatternElement getSelectedElement() {
        IStructuredSelection ss = (IStructuredSelection)this.viewer.getSelection();
        return (PatternElement)ss.getFirstElement();
    }

    public IWizardPage getNextPage() {
        return this.getWizard().getPage(this.nextPage());
    }

    public String nextPage() {
        PatternElement element = this.getSelectedElement();
        if (element != null) {
            return element.pname;
        }
        return null;
    }

    class LP
    extends LabelProvider {
        LP() {
        }

        public String getText(Object element) {
            return ((PatternElement)element).name;
        }

        public Image getImage(Object element) {
            PatternElement pelement = (PatternElement)element;
            if (pelement.imgid != null) {
                return ApiUIPlugin.getSharedImage(pelement.imgid);
            }
            return null;
        }
    }

    class PatternElement {
        String name = null;
        String desc = null;
        String imgid = null;
        String pname = null;

        public PatternElement(String name, String desc, String imgid, String pname) {
            this.name = name;
            this.desc = desc;
            this.imgid = imgid;
            this.pname = pname;
        }
    }
}

