/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.features.paging;

import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.resources.common.AbstractResource;

abstract class AbstractPagingValidator {
    private int offset;
    private int limit;
    private final UriInfo uri;
    final Map<String, Object> queryParameters;

    AbstractPagingValidator(UriInfo uri) {
        this.queryParameters = AbstractResource.getQueryParameters(uri);
        this.uri = uri;
    }

    abstract boolean isFeatureApplicable() throws JPARSException;

    void checkParameters(int defaultLimit) {
        String paramLimit = (String)this.queryParameters.get("limit");
        String paramOffset = (String)this.queryParameters.get("offset");
        try {
            int intLimit;
            this.limit = paramLimit != null ? ((intLimit = Integer.parseInt(paramLimit)) > defaultLimit ? defaultLimit : intLimit) : defaultLimit;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(String.format("Invalid 'limit' parameter value (limit=%s).", paramLimit));
        }
        try {
            if (paramOffset != null) {
                this.offset = Integer.parseInt(paramOffset);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(String.format("Invalid 'offset' parameter value (offset=%s).", paramOffset));
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }
}

