/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.NamespaceUseNameContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;

public class NamespaceUseTraitNameStrategy
extends AbstractCompletionStrategy {
    public NamespaceUseTraitNameStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof NamespaceUseNameContext)) {
            return;
        }
        NamespaceUseNameContext concreteContext = (NamespaceUseNameContext)context;
        String suffix = "";
        ISourceRange replaceRange = this.getReplacementRange(concreteContext);
        IType[] iTypeArray = this.getTypes(concreteContext);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            reporter.reportType(type, suffix, replaceRange, this.getExtraInfo());
            ++n2;
        }
    }

    public IType[] getTypes(NamespaceUseNameContext context) throws BadLocationException {
        if (context.getNamespaces() == null) {
            return new IType[0];
        }
        String prefix = context.getPrefix();
        LinkedList<IType> result = new LinkedList<IType>();
        IType[] iTypeArray = context.getNamespaces();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType ns = iTypeArray[n2];
            try {
                IType[] iTypeArray2 = ns.getTypes();
                int n3 = iTypeArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IType type = iTypeArray2[n4];
                    if (PHPFlags.isTrait(type.getFlags()) && StringUtils.startsWithIgnoreCase((CharSequence)type.getElementName(), (CharSequence)prefix)) {
                        result.add(type);
                    }
                    ++n4;
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    public String getSuffix(AbstractCompletionContext abstractContext) {
        String nextWord = null;
        try {
            nextWord = abstractContext.getNextWord();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return "::".equals(nextWord) ? "" : "::";
    }

    protected int getExtraInfo() {
        return 2;
    }
}

