/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.decoration;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.DRepresentationElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.decoration.DecorationDescriptor;
import org.eclipse.sirius.diagram.ui.tools.api.decoration.SiriusDecorationDescriptorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.DecorationDistributionDirection;
import org.eclipse.sirius.viewpoint.description.Position;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationNavigationDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.swt.graphics.Image;

public class SubDiagramDecorationDescriptorProvider
implements SiriusDecorationDescriptorProvider {
    private static final String NAME = "subDiagramStatus";

    @Override
    public boolean provides(IDiagramElementEditPart editPart) {
        if (editPart instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart || editPart instanceof AbstractConnectionEditPart) {
            Optional<View> view = Optional.ofNullable((View)editPart.getModel());
            return view.filter(View::isSetElement).map(View::getElement).filter(model -> model instanceof DNode || model instanceof DDiagramElementContainer).isPresent();
        }
        return false;
    }

    @Override
    public List<DecorationDescriptor> getDecorationDescriptors(IDiagramElementEditPart editPart, Session session) {
        DRepresentationElement node;
        EObject model = ((View)editPart.getModel()).getElement();
        if (model instanceof DRepresentationElement && this.shouldHaveSubDiagDecoration(node = (DRepresentationElement)model, session)) {
            DecorationDescriptor decoDesc = new DecorationDescriptor();
            decoDesc.setName(NAME);
            decoDesc.setPosition(Position.SOUTH_EAST_LITERAL);
            decoDesc.setDistributionDirection(DecorationDistributionDirection.HORIZONTAL);
            decoDesc.setDisplayPriority(DecorationDescriptor.DisplayPriority.HIGH_PRIORITY.getValue());
            decoDesc.setDecorationAsImage(this.getSubDiagramImage());
            return Arrays.asList(decoDesc);
        }
        return new ArrayList<DecorationDescriptor>();
    }

    private Image getSubDiagramImage() {
        return WorkspaceImageFigure.flyWeightImage(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/HasLink.gif"));
    }

    private boolean shouldHaveSubDiagDecoration(DRepresentationElement node, Session session) {
        EObject target = node.getTarget();
        boolean shouldHaveSubDiagramDecorator = false;
        if (target != null && target.eResource() != null && session != null && !this.parentHasSameSemanticElement(node)) {
            DRepresentation representation = new DRepresentationElementQuery(node).getParentRepresentation();
            Predicate otherReperesentation = Predicates.not((Predicate)Predicates.equalTo((Object)representation));
            shouldHaveSubDiagramDecorator = Iterables.any((Iterable)DialectManager.INSTANCE.getRepresentations(target, session), (Predicate)otherReperesentation);
            if (node.getMapping() != null && !shouldHaveSubDiagramDecorator) {
                shouldHaveSubDiagramDecorator = this.checkRepresentationNavigationDescriptions(node, session);
            }
        }
        return shouldHaveSubDiagramDecorator;
    }

    private boolean parentHasSameSemanticElement(DRepresentationElement element) {
        return element.eContainer() instanceof DDiagramElement && ((DDiagramElement)element.eContainer()).getTarget() == element.getTarget();
    }

    private boolean checkRepresentationNavigationDescriptions(DRepresentationElement element, Session session) {
        EObject target = element.getTarget();
        if (session.isOpen()) {
            IInterpreter interpreter = session.getInterpreter();
            for (RepresentationNavigationDescription navDesc : element.getMapping().getNavigationDescriptions()) {
                if (!this.isFromActiveViewpoint(navDesc.getRepresentationDescription(), session)) continue;
                interpreter.setVariable(navDesc.getContainerVariable().getName(), (Object)target);
                interpreter.setVariable(navDesc.getContainerViewVariable().getName(), (Object)element);
                boolean precondition = true;
                if (!StringUtil.isEmpty((String)navDesc.getPrecondition())) {
                    try {
                        precondition = interpreter.evaluateBoolean(target, navDesc.getPrecondition());
                    }
                    catch (EvaluationException e) {
                        RuntimeLoggerManager.INSTANCE.error((EObject)navDesc, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
                    }
                }
                if (precondition && this.checkRepresentationNavigationDescription(interpreter, navDesc, element, session)) {
                    return true;
                }
                interpreter.unSetVariable(navDesc.getContainerVariable().getName());
                interpreter.unSetVariable(navDesc.getContainerViewVariable().getName());
            }
        }
        return false;
    }

    private boolean isFromActiveViewpoint(RepresentationDescription description, Session session) {
        Viewpoint vp = ViewpointRegistry.getInstance().getViewpoint(description);
        return vp != null && session.getSelectedViewpoints(false).contains(vp);
    }

    private boolean checkRepresentationNavigationDescription(IInterpreter interpreter, RepresentationNavigationDescription navDesc, DRepresentationElement element, Session session) {
        Collection<EObject> candidates = null;
        if (!StringUtil.isEmpty((String)navDesc.getBrowseExpression())) {
            candidates = RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateCollection(element.getTarget(), (EObject)navDesc, (EStructuralFeature)ToolPackage.eINSTANCE.getRepresentationNavigationDescription_BrowseExpression());
        } else {
            candidates = new ArrayList();
            TreeIterator it = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(element.getTarget()).eAllContents(element.getTarget());
            while (it.hasNext()) {
                candidates.add((EObject)it.next());
            }
        }
        for (EObject candidate : candidates) {
            Collection representations = DialectManager.INSTANCE.getRepresentations(candidate, session);
            for (DRepresentation representation : representations) {
                if (navDesc.getRepresentationDescription() == null || !navDesc.getRepresentationDescription().equals(DialectManager.INSTANCE.getDescription(representation))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void activate(IDecoratorTarget decoratorTarget, IDecorator decorator, GraphicalEditPart editPart) {
    }

    @Override
    public void deactivate(IDecorator decorator, GraphicalEditPart editPart) {
    }
}

