/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.resources;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sphinx.platform.resources.IProblemMarkerFinder;

public abstract class AbstractProblemMarkerFinder
implements IProblemMarkerFinder {
    protected Map<Object, Integer> severityCache = new HashMap<Object, Integer>();

    protected boolean canHaveProblemMarkers(Object object) {
        return true;
    }

    @Override
    public int getSeverity(Object object) throws CoreException {
        if (!this.canHaveProblemMarkers(object)) {
            return -1;
        }
        Integer overallSeverity = this.severityCache.get(object);
        if (overallSeverity != null) {
            return overallSeverity;
        }
        overallSeverity = -1;
        for (IMarker problemMarker : this.getProblemMarkers(object)) {
            int severity = problemMarker.getAttribute("severity", -1);
            if (severity > overallSeverity) {
                overallSeverity = severity;
            }
            if (overallSeverity == 2) break;
        }
        this.severityCache.put(object, overallSeverity);
        return overallSeverity;
    }

    @Override
    public void reset() {
        this.severityCache.clear();
    }
}

