/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.repository.model;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.operation.remote.GetRemoteFolderChildrenOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.repository.model.IParentTreeNode;
import org.eclipse.team.svn.ui.repository.model.RepositoryBranches;
import org.eclipse.team.svn.ui.repository.model.RepositoryError;
import org.eclipse.team.svn.ui.repository.model.RepositoryFile;
import org.eclipse.team.svn.ui.repository.model.RepositoryPending;
import org.eclipse.team.svn.ui.repository.model.RepositoryResource;
import org.eclipse.team.svn.ui.repository.model.RepositoryRoot;
import org.eclipse.team.svn.ui.repository.model.RepositoryTags;
import org.eclipse.team.svn.ui.repository.model.RepositoryTrunk;
import org.eclipse.team.svn.ui.utility.DefaultOperationWrapperFactory;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.PlatformUI;

public class RepositoryFolder
extends RepositoryResource
implements IParentTreeNode {
    protected GetRemoteFolderChildrenOperation childrenOp;
    protected Object[] wrappedChildren;

    public RepositoryFolder(RepositoryResource parent, IRepositoryResource resource) {
        super(parent, resource);
    }

    public void refresh() {
        this.childrenOp = null;
        this.wrappedChildren = null;
        super.refresh();
    }

    public boolean hasChildren() {
        return true;
    }

    public Object[] getChildren(Object o) {
        IRepositoryContainer container = (IRepositoryContainer)this.resource;
        if (this.wrappedChildren != null) {
            return this.wrappedChildren;
        }
        if (this.childrenOp != null) {
            Object[] retVal = RepositoryFolder.wrapChildren(this, this.childrenOp.getChildren(), this.childrenOp);
            if (retVal != null) {
                this.wrappedChildren = retVal;
            } else if (this.childrenOp.getExecutionState() != 1) {
                retVal = new Object[]{new RepositoryPending(this)};
            } else {
                this.wrappedChildren = new Object[]{new RepositoryError(this.childrenOp.getStatus())};
                retVal = this.wrappedChildren;
            }
            return retVal;
        }
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        this.childrenOp = new GetRemoteFolderChildrenOperation(container, SVNTeamPreferences.getRepositoryBoolean(store, "showExternals"), SVNTeamPreferences.getBehaviourBoolean(store, "sorting.case.insensitive"));
        CompositeOperation op = new CompositeOperation(this.childrenOp.getId(), this.childrenOp.getMessagesClass());
        op.add((IActionOperation)this.childrenOp);
        op.add((IActionOperation)this.getRefreshOperation(this.getViewer()));
        UIMonitorUtility.doTaskScheduled((IActionOperation)op, new DefaultOperationWrapperFactory(){

            public IActionOperation getLogged(IActionOperation operation) {
                return new LoggedOperation(operation);
            }
        });
        return new Object[]{new RepositoryPending(this)};
    }

    public Object[] peekChildren(Object o) {
        Object[] objectArray;
        if (this.childrenOp == null) {
            return this.getChildren(o);
        }
        Object[] retVal = RepositoryFolder.wrapChildren(this, this.childrenOp.getChildren(), this.childrenOp);
        if (retVal == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.childrenOp.getExecutionState() != 1 ? new RepositoryPending(this) : new RepositoryError(this.childrenOp.getStatus());
        } else {
            objectArray = retVal;
        }
        return objectArray;
    }

    public static RepositoryResource[] wrapChildren(RepositoryResource parent, IRepositoryResource[] resources, GetRemoteFolderChildrenOperation childrenOp) {
        if (resources == null) {
            return null;
        }
        RepositoryResource[] wrappers = new RepositoryResource[resources.length];
        int i = 0;
        while (i < resources.length) {
            String externalsName = childrenOp != null ? childrenOp.getExternalsName(i) : null;
            wrappers[i] = RepositoryFolder.wrapChild(parent, resources[i], externalsName);
            ++i;
        }
        return wrappers;
    }

    public static RepositoryResource wrapChild(RepositoryResource parent, IRepositoryResource resource, String externalsName) {
        RepositoryResource retVal = null;
        if (resource instanceof IRepositoryRoot && externalsName == null) {
            IRepositoryRoot tmp = (IRepositoryRoot)resource;
            switch (tmp.getKind()) {
                case 1: {
                    retVal = new RepositoryTrunk(parent, (IRepositoryResource)tmp);
                    break;
                }
                case 2: {
                    retVal = new RepositoryBranches(parent, (IRepositoryResource)tmp);
                    break;
                }
                case 3: {
                    retVal = new RepositoryTags(parent, (IRepositoryResource)tmp);
                    break;
                }
                default: {
                    retVal = new RepositoryRoot(parent, (IRepositoryResource)tmp);
                    break;
                }
            }
        } else {
            RepositoryResource repositoryResource = retVal = resource instanceof IRepositoryFile ? new RepositoryFile(parent, resource) : new RepositoryFolder(parent, resource);
            if (externalsName != null) {
                retVal.setLabel(externalsName);
                retVal.setExternals(true);
            }
        }
        return retVal;
    }

    protected ImageDescriptor getImageDescriptorImpl() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
    }
}

