/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.registry.LinuxStyle;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class ControlFlowPresentationProvider
extends TimeGraphPresentationProvider {
    private static final Map<Integer, StateItem> STATE_MAP;
    private static final List<StateItem> STATE_LIST;
    private static final StateItem[] STATE_TABLE;
    private Integer fAverageCharacterWidth = null;

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)0, (Object)ControlFlowPresentationProvider.createState(LinuxStyle.UNKNOWN));
        builder.put((Object)2, (Object)ControlFlowPresentationProvider.createState(LinuxStyle.USERMODE));
        builder.put((Object)3, (Object)ControlFlowPresentationProvider.createState(LinuxStyle.SYSCALL));
        builder.put((Object)4, (Object)ControlFlowPresentationProvider.createState(LinuxStyle.INTERRUPTED));
        builder.put((Object)1, (Object)ControlFlowPresentationProvider.createState(LinuxStyle.WAIT_BLOCKED));
        builder.put((Object)5, (Object)ControlFlowPresentationProvider.createState(LinuxStyle.WAIT_FOR_CPU));
        builder.put((Object)6, (Object)ControlFlowPresentationProvider.createState(LinuxStyle.WAIT_UNKNOWN));
        STATE_MAP = builder.build();
        STATE_LIST = ImmutableList.copyOf(STATE_MAP.values());
        STATE_TABLE = STATE_LIST.toArray(new StateItem[STATE_LIST.size()]);
    }

    private static StateItem createState(final LinuxStyle style) {
        int rgbInt = (Integer)style.toMap().getOrDefault(ITimeEventStyleStrings.fillColor(), 0);
        RGB color = new RGB(rgbInt >> 24 & 0xFF, rgbInt >> 16 & 0xFF, rgbInt >> 8 & 0xFF);
        return new StateItem(color, style.getLabel()){

            public Map<String, Object> getStyleMap() {
                return style.toMap();
            }
        };
    }

    public ControlFlowPresentationProvider() {
        super(Messages.ControlFlowView_stateTypeName);
    }

    public StateItem[] getStateTable() {
        return STATE_TABLE;
    }

    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            int status = ((TimeEvent)event).getValue();
            return STATE_LIST.indexOf(ControlFlowPresentationProvider.getMatchingState(status));
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return -2;
    }

    public String getEventName(ITimeEvent event) {
        TimeEvent ev;
        if (event instanceof TimeEvent && (ev = (TimeEvent)event).hasValue()) {
            return ControlFlowPresentationProvider.getMatchingState(ev.getValue()).getStateString();
        }
        return Messages.ControlFlowView_multipleStates;
    }

    private static StateItem getMatchingState(int status) {
        return STATE_MAP.getOrDefault(status, STATE_MAP.get(6));
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        if (!(event instanceof TimeEvent && ((TimeEvent)event).hasValue() && event.getEntry() instanceof ControlFlowEntry)) {
            return retMap;
        }
        ControlFlowEntry entry = (ControlFlowEntry)event.getEntry();
        ITmfStateSystem ssq = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)entry.getTrace(), (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (ssq == null) {
            return retMap;
        }
        int tid = entry.getThreadId();
        try {
            int cpusQuark = ssq.getQuarkAbsolute(new String[]{"CPUs"});
            List cpuQuarks = ssq.getSubAttributes(cpusQuark, false);
            for (Integer cpuQuark : cpuQuarks) {
                ITmfStateValue state;
                int currentThreadId;
                int currentThreadQuark = ssq.getQuarkRelative(cpuQuark.intValue(), new String[]{"Current_thread"});
                ITmfStateInterval interval = ssq.querySingleState(event.getTime(), currentThreadQuark);
                if (interval.getStateValue().isNull() || tid != (currentThreadId = (state = interval.getStateValue()).unboxInt())) continue;
                retMap.put(Messages.ControlFlowView_attributeCpuName, ssq.getAttributeName(cpuQuark.intValue()));
                break;
            }
        }
        catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
            Activator.getDefault().logError("Error in ControlFlowPresentationProvider", e);
        }
        catch (StateSystemDisposedException e) {
            // empty catch block
        }
        int status = ((TimeEvent)event).getValue();
        if (status == 3) {
            int syscallQuark = ssq.optQuarkRelative(entry.getThreadQuark(), new String[]{"System_call"});
            if (syscallQuark == -2) {
                return retMap;
            }
            try {
                ITmfStateInterval value = ssq.querySingleState(event.getTime(), syscallQuark);
                if (!value.getStateValue().isNull()) {
                    ITmfStateValue state = value.getStateValue();
                    retMap.put(Messages.ControlFlowView_attributeSyscallName, state.toString());
                }
            }
            catch (TimeRangeException e) {
                Activator.getDefault().logError("Error in ControlFlowPresentationProvider", e);
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {
                // empty catch block
            }
        }
        return retMap;
    }

    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
        if (this.fAverageCharacterWidth == null) {
            this.fAverageCharacterWidth = gc.getFontMetrics().getAverageCharWidth();
        }
        if (bounds.width <= this.fAverageCharacterWidth) {
            return;
        }
        if (!(event instanceof TimeEvent)) {
            return;
        }
        ControlFlowEntry entry = (ControlFlowEntry)event.getEntry();
        ITmfStateSystem ss = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)entry.getTrace(), (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (ss == null) {
            return;
        }
        int status = ((TimeEvent)event).getValue();
        if (status != 3) {
            return;
        }
        int syscallQuark = ss.optQuarkRelative(entry.getThreadQuark(), new String[]{"System_call"});
        if (syscallQuark == -2) {
            return;
        }
        try {
            ITmfStateInterval value = ss.querySingleState(event.getTime(), syscallQuark);
            if (!value.getStateValue().isNull()) {
                ITmfStateValue state = value.getStateValue();
                gc.setForeground(gc.getDevice().getSystemColor(1));
                int beginIndex = 0;
                ITmfTrace trace = entry.getTrace();
                if (trace instanceof IKernelTrace) {
                    IKernelAnalysisEventLayout layout = ((IKernelTrace)trace).getKernelEventLayout();
                    beginIndex = layout.eventSyscallEntryPrefix().length();
                }
                Utils.drawText((GC)gc, (String)state.toString().substring(beginIndex), (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, (boolean)true, (boolean)true);
            }
        }
        catch (TimeRangeException e) {
            Activator.getDefault().logError("Error in ControlFlowPresentationProvider", e);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
    }
}

