/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

@NonNullByDefault
public final class StateSystemUtils {
    private StateSystemUtils() {
    }

    public static @Nullable ITmfStateInterval querySingleStackTop(ITmfStateSystem ss, long t, int stackAttributeQuark) throws AttributeNotFoundException, StateSystemDisposedException {
        @Nullable Object curStackStateValue = ss.querySingleState(t, stackAttributeQuark).getValue();
        if (curStackStateValue == null) {
            return null;
        }
        if (!(curStackStateValue instanceof Integer)) {
            throw new IllegalStateException(String.valueOf(ss.getSSID()) + "Quark: " + stackAttributeQuark + ", expected Integer.class, value was " + curStackStateValue.getClass());
        }
        int curStackDepth = (Integer)curStackStateValue;
        if (curStackDepth <= 0) {
            throw new StateValueTypeException(String.valueOf(ss.getSSID()) + " Quark:" + stackAttributeQuark + ", Stack depth:" + curStackDepth);
        }
        int subAttribQuark = ss.getQuarkRelative(stackAttributeQuark, String.valueOf(curStackDepth));
        return ss.querySingleState(t, subAttribQuark);
    }

    public static List<ITmfStateInterval> queryHistoryRange(ITmfStateSystem ss, int attributeQuark, long t1, long t2) throws AttributeNotFoundException, StateSystemDisposedException {
        if (t2 < t1) {
            throw new TimeRangeException(String.valueOf(ss.getSSID()) + " Start:" + t1 + ", End:" + t2);
        }
        long tEnd = t2 > ss.getCurrentEndTime() ? ss.getCurrentEndTime() : t2;
        ArrayList<ITmfStateInterval> intervals = new ArrayList<ITmfStateInterval>();
        ITmfStateInterval currentInterval = ss.querySingleState(t1, attributeQuark);
        intervals.add(currentInterval);
        long ts = currentInterval.getEndTime();
        while (ts != -1L && ts < tEnd) {
            currentInterval = ss.querySingleState(++ts, attributeQuark);
            intervals.add(currentInterval);
            ts = currentInterval.getEndTime();
        }
        return intervals;
    }

    public static List<ITmfStateInterval> queryHistoryRange(ITmfStateSystem ss, int attributeQuark, long t1, long t2, long resolution, @Nullable IProgressMonitor monitor) throws AttributeNotFoundException, StateSystemDisposedException {
        LinkedList<ITmfStateInterval> intervals = new LinkedList<ITmfStateInterval>();
        ITmfStateInterval currentInterval = null;
        if (t2 < t1 || resolution <= 0L) {
            throw new TimeRangeException(String.valueOf(ss.getSSID()) + " Start:" + t1 + ", End:" + t2 + ", Resolution:" + resolution);
        }
        long tEnd = t2 > ss.getCurrentEndTime() ? ss.getCurrentEndTime() : t2;
        IProgressMonitor mon = monitor;
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        long ts = t1;
        while (ts <= tEnd) {
            if (mon.isCanceled()) {
                return intervals;
            }
            currentInterval = ss.querySingleState(ts, attributeQuark);
            intervals.add(currentInterval);
            ts += ((currentInterval.getEndTime() - ts) / resolution + 1L) * resolution;
        }
        if (currentInterval != null && currentInterval.getEndTime() < tEnd) {
            currentInterval = ss.querySingleState(tEnd, attributeQuark);
            intervals.add(currentInterval);
        }
        return intervals;
    }

    /*
     * Exception decompiling
     */
    public static @Nullable ITmfStateInterval queryUntilNonNullValue(ITmfStateSystem ss, int attributeQuark, long t1, long t2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<Long> getTimes(long from, long to, long resolution) {
        if (to < from || resolution < 0L) {
            throw new IllegalArgumentException();
        }
        long increment = Math.max(resolution, 1L);
        ArrayList<Long> times = new ArrayList<Long>((int)((to - from) / increment + 1L));
        long t = from;
        while (t < to) {
            times.add(t);
            t += increment;
        }
        times.add(to);
        return times;
    }

    public static class QuarkIterator
    implements Iterator<ITmfStateInterval> {
        private final ITmfStateSystem fSS;
        private final int fQuark;
        private final long fInitialTime;
        private @Nullable ITmfStateInterval fCurrent;

        public QuarkIterator(ITmfStateSystem ss, int quark, long initialTime) {
            this.fSS = ss;
            this.fQuark = quark;
            this.fInitialTime = initialTime;
        }

        private long getNextQueryTime() {
            if (this.fCurrent != null) {
                return this.fCurrent.getEndTime() + 1L;
            }
            return Long.max(this.fInitialTime, this.fSS.getStartTime());
        }

        private long getPreviousQueryTime() {
            if (this.fCurrent != null) {
                return this.fCurrent.getStartTime() - 1L;
            }
            return Long.min(this.fInitialTime, this.fSS.getCurrentEndTime());
        }

        @Override
        public boolean hasNext() {
            return this.getNextQueryTime() <= this.fSS.getCurrentEndTime();
        }

        @Override
        public ITmfStateInterval next() {
            if (this.hasNext()) {
                try {
                    this.fCurrent = this.fSS.querySingleState(this.getNextQueryTime(), this.fQuark);
                    return this.fCurrent;
                }
                catch (StateSystemDisposedException stateSystemDisposedException) {
                    // empty catch block
                }
            }
            throw new NoSuchElementException();
        }

        public boolean hasPrevious() {
            return this.getPreviousQueryTime() >= this.fSS.getStartTime();
        }

        public ITmfStateInterval previous() {
            if (this.hasPrevious()) {
                try {
                    this.fCurrent = this.fSS.querySingleState(this.getPreviousQueryTime(), this.fQuark);
                    return this.fCurrent;
                }
                catch (StateSystemDisposedException stateSystemDisposedException) {
                    // empty catch block
                }
            }
            throw new NoSuchElementException();
        }
    }
}

