/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.statistics;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfLostEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TmfStatisticsTotalsModule
extends TmfStateSystemAnalysisModule {
    public static final @NonNull String ID = "org.eclipse.linuxtools.tmf.statistics.totals";
    private static final @NonNull String NAME = "TMF Statistics, event totals";

    public TmfStatisticsTotalsModule() {
        this.setId(ID);
        this.setName(NAME);
    }

    @Override
    protected ITmfStateProvider createStateProvider() {
        return new StatsProviderTotals((ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace()));
    }

    @Override
    protected String getSsFileName() {
        return "statistics-totals.ht";
    }

    class StatsProviderTotals
    extends AbstractTmfStateProvider {
        private static final int VERSION = 2;

        public StatsProviderTotals(ITmfTrace trace) {
            super(trace, TmfStatisticsTotalsModule.NAME);
        }

        @Override
        public int getVersion() {
            return 2;
        }

        @Override
        public StatsProviderTotals getNewInstance() {
            return new StatsProviderTotals(this.getTrace());
        }

        @Override
        protected void eventHandle(ITmfEvent event) {
            if (event instanceof ITmfLostEvent) {
                return;
            }
            ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
            long ts = event.getTimestamp().toNanos();
            try {
                int quark = ss.getQuarkAbsoluteAndAdd(new String[]{"total"});
                StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)ss, (long)ts, (int)quark, (int)1);
            }
            catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
                e.printStackTrace();
            }
        }
    }
}

