/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class TmfProjectRegistry
implements IResourceChangeListener {
    private static final TmfProjectRegistry INSTANCE = new TmfProjectRegistry();
    private static Map<IProject, TmfProjectElement> registry = new HashMap<IProject, TmfProjectElement>();
    private static Queue<TmfTraceElement> promptQueue = new ArrayDeque<TmfTraceElement>();

    private TmfProjectRegistry() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        TmfSignalManager.register((Object)this);
    }

    public static void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)INSTANCE);
        TmfSignalManager.deregister((Object)INSTANCE);
        registry.values().forEach(projectElement -> projectElement.dispose());
    }

    public static synchronized TmfProjectElement getProject(IProject project) {
        return TmfProjectRegistry.getProject(project, false);
    }

    public static synchronized TmfProjectElement getProject(IProject project, boolean force) {
        TmfProjectElement element = registry.get(project);
        if (element == null && force) {
            element = new TmfProjectElement(project.getName(), project, null);
            registry.put(project, element);
            element.refreshChildren();
        }
        return element;
    }

    public static IProject createProject(String projectName, final URI projectLocation, IProgressMonitor monitor) {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        final IProject project = root.getProject(projectName);
        WorkspaceModifyOperation action = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
                IProjectDescription description;
                if (!project.exists()) {
                    description = workspace.newProjectDescription(project.getName());
                    if (projectLocation != null) {
                        description.setLocationURI(projectLocation);
                    }
                    project.create(description, progressMonitor);
                }
                if (!project.isOpen()) {
                    project.open(progressMonitor);
                }
                description = project.getDescription();
                description.setNatureIds(new String[]{"org.eclipse.linuxtools.tmf.project.nature"});
                project.setDescription(description, null);
                IFolder folder = project.getFolder("Traces");
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                if (!(folder = project.getFolder("Experiments")).exists()) {
                    folder.create(true, true, null);
                }
                if (!(folder = project.getFolder(".tracing")).exists()) {
                    folder.create(true, true, null);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, (IRunnableWithProgress)action);
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().logError("Error creating TMF project " + project.getName(), e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return project;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        block22: {
            if (event.getType() == 4 || event.getType() == 2) {
                if (event.getResource() instanceof IProject) {
                    IProject project = (IProject)event.getResource();
                    try {
                        List<TmfTraceElement> traces;
                        if (!project.isAccessible() || !project.hasNature("org.eclipse.linuxtools.tmf.project.nature")) break block22;
                        TmfProjectElement tmfProjectElement = registry.get(project);
                        if (tmfProjectElement == null) {
                            return;
                        }
                        TmfTraceFolder tracesFolder = tmfProjectElement.getTracesFolder();
                        if (tracesFolder != null && !(traces = tracesFolder.getTraces()).isEmpty()) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    for (TmfTraceElement traceElement : traces) {
                                        traceElement.closeEditors();
                                    }
                                }
                            });
                        }
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError("Error handling resource change event for " + project.getName(), e);
                    }
                }
            } else if (event.getType() == 1) {
                IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta delta = iResourceDeltaArray[n2];
                    if (delta.getResource() instanceof IProject) {
                        IProject project = (IProject)delta.getResource();
                        try {
                            TmfProjectElement projectElement;
                            if (delta.getKind() == 4 && project.isOpen() && project.hasNature("org.eclipse.linuxtools.tmf.project.nature")) {
                                ITmfProjectModelElement element2;
                                HashSet resourcesToRefresh = new HashSet();
                                event.getDelta().accept(visited -> {
                                    if ((visited.getFlags() & 0x100) != 0) {
                                        resourcesToRefresh.add(visited.getResource());
                                    } else if (visited.getKind() != 4) {
                                        resourcesToRefresh.add(visited.getResource().getParent());
                                    }
                                    return true;
                                });
                                HashSet<ITmfProjectModelElement> elementsToRefresh = new HashSet<ITmfProjectModelElement>();
                                for (IResource resource : resourcesToRefresh) {
                                    element2 = TmfProjectRegistry.findElement(resource, false);
                                    if (element2 == null) continue;
                                    elementsToRefresh.add(element2);
                                }
                                HashSet<TmfTraceElement> changedTraces = new HashSet<TmfTraceElement>();
                                Iterator iterator = elementsToRefresh.iterator();
                                block6: while (iterator.hasNext()) {
                                    element2 = (ITmfProjectModelElement)iterator.next();
                                    if (element2 instanceof TmfTraceElement) {
                                        changedTraces.add(((TmfTraceElement)element2).getElementUnderTraceFolder());
                                    }
                                    for (ITmfProjectModelElement parent : elementsToRefresh) {
                                        if (!parent.getPath().isPrefixOf(element2.getPath()) || parent.equals(element2)) continue;
                                        iterator.remove();
                                        continue block6;
                                    }
                                }
                                for (TmfTraceElement trace : changedTraces) {
                                    TmfProjectRegistry.handleTraceContentChanged(trace);
                                }
                                for (ITmfProjectModelElement element2 : elementsToRefresh) {
                                    element2.refresh();
                                }
                                TmfProjectElement projectElement2 = registry.get(project);
                                if (projectElement2 != null) {
                                    projectElement2.refreshViewer();
                                }
                            } else if (delta.getKind() == 2 && (projectElement = registry.remove(project)) != null) {
                                projectElement.dispose();
                            }
                        }
                        catch (CoreException e) {
                            Activator.getDefault().logError("Error handling resource change event for " + project.getName(), e);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        ITmfProjectModelElement element = TmfProjectRegistry.findElement(signal.getTrace().getResource(), true);
        if (element != null) {
            element.refresh();
            if (element instanceof TmfExperimentElement) {
                TmfExperimentElement experiment = (TmfExperimentElement)element;
                for (TmfTraceElement trace : experiment.getTraces()) {
                    trace.getElementUnderTraceFolder().refresh();
                }
            }
        }
    }

    public static ITmfProjectModelElement findElement(IResource resource, boolean exact) {
        if (resource == null) {
            return null;
        }
        ITmfProjectModelElement element = TmfProjectRegistry.getProject(resource.getProject());
        if (element == null) {
            return null;
        }
        String[] stringArray = resource.getProjectRelativePath().segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            List<ITmfProjectModelElement> children = element.getChildren();
            boolean match = false;
            for (ITmfProjectModelElement child : children) {
                IResource childResource = child.getResource();
                if (childResource == null || !segment.equals(childResource.getName())) continue;
                element = child;
                match = true;
                break;
            }
            if (!match) {
                return exact ? null : (element instanceof TmfProjectElement ? null : element);
            }
            ++n2;
        }
        return element;
    }

    private static void handleTraceContentChanged(TmfTraceElement traceElement) {
        Display.getDefault().asyncExec(() -> {
            boolean opened = false;
            block0: for (ITmfTrace openedTrace : TmfTraceManager.getInstance().getOpenedTraces()) {
                for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)openedTrace)) {
                    if (!traceElement.getResource().equals((Object)trace.getResource())) continue;
                    opened = true;
                    continue block0;
                }
            }
            if (!opened) {
                traceElement.deleteSupplementaryResources();
                return;
            }
            if (!promptQueue.isEmpty()) {
                if (!promptQueue.contains(traceElement)) {
                    promptQueue.add(traceElement);
                }
                return;
            }
            promptQueue.add(traceElement);
            TmfTraceElement prompting = traceElement;
            while (prompting != null) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                if (MessageDialog.openQuestion((Shell)shell, (String)Messages.TmfProjectRegistry_TraceChangedDialogTitle, (String)NLS.bind((String)Messages.TmfProjectRegistry_TraceChangedDialogMessage, (Object)prompting.getElementPath()))) {
                    traceElement.closeEditors();
                    traceElement.deleteSupplementaryResources();
                }
                promptQueue.remove();
                prompting = promptQueue.peek();
            }
        });
    }
}

