/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.timegraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.tmf.ui.TmfUiRefreshHandler;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.VirtualTimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;

public abstract class AbstractVirtualTimeGraphView
extends AbstractTimeGraphView {
    private static final int DEFAULT_BUFFER_SIZE = 10;
    private List<ILinkEvent> fLinkCache = null;
    private VirtualTimeGraphEntry.Sampling fLastSampling = null;
    private @NonNull Set<ITimeGraphEntry> fVisibleEntries = Collections.emptySet();

    public AbstractVirtualTimeGraphView(String id, TimeGraphPresentationProvider pres) {
        super(id, pres);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getTimeGraphViewer().getTimeGraphControl().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TmfUiRefreshHandler.getInstance().queueUpdate(this, () -> {
                    @NonNull Set newSet = AbstractVirtualTimeGraphView.this.getVisibleItems(10);
                    if (!AbstractVirtualTimeGraphView.this.fVisibleEntries.equals(newSet)) {
                        AbstractVirtualTimeGraphView.this.fVisibleEntries = newSet;
                        AbstractVirtualTimeGraphView.this.startZoomThread(AbstractVirtualTimeGraphView.this.getTimeGraphViewer().getTime0(), AbstractVirtualTimeGraphView.this.getTimeGraphViewer().getTime1());
                    }
                });
            }
        });
    }

    private @NonNull Set<ITimeGraphEntry> getVisibleItems(int buffer) {
        TimeGraphViewer timeGraphViewer = this.getTimeGraphViewer();
        TimeGraphControl timeGraphControl = timeGraphViewer.getTimeGraphControl();
        int start = Math.max(0, timeGraphViewer.getTopIndex() - buffer);
        int end = Math.min(timeGraphViewer.getExpandedElementCount() - 1, timeGraphViewer.getTopIndex() + timeGraphControl.countPerPage() + buffer);
        HashSet<ITimeGraphEntry> visible = new HashSet<ITimeGraphEntry>(end - start + 1);
        int i = start;
        while (i <= end) {
            visible.add(timeGraphControl.getExpandedElement(i));
            ++i;
        }
        return visible;
    }

    @Override
    protected @Nullable AbstractTimeGraphView.ZoomThread createZoomThread(long startTime, long endTime, long resolution, boolean restart) {
        return new ZoomThreadVisible(startTime, endTime, resolution);
    }

    protected abstract void zoomEntries(@NonNull Iterable<ITimeGraphEntry> var1, long var2, long var4, long var6, @NonNull IProgressMonitor var8);

    @Override
    protected @Nullable List<@NonNull ITimeEvent> getEventList(@NonNull TimeGraphEntry entry, long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public class ZoomThreadVisible
    extends AbstractTimeGraphView.ZoomThread {
        public ZoomThreadVisible(long startTime, long endTime, long resolution) {
            super(AbstractVirtualTimeGraphView.this, startTime, endTime, resolution);
        }

        @Override
        public void doRun() {
            @NonNull VirtualTimeGraphEntry.Sampling sampling = new VirtualTimeGraphEntry.Sampling(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution());
            Iterable<ITimeGraphEntry> newVisibleEntries = this.filterEntries(AbstractVirtualTimeGraphView.this.fVisibleEntries, sampling);
            AbstractVirtualTimeGraphView.this.zoomEntries(newVisibleEntries, this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor());
            List<ILinkEvent> links = this.getLinks(sampling);
            List<IMarkerEvent> markers = AbstractVirtualTimeGraphView.this.getViewMarkerList(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor());
            markers.addAll(AbstractVirtualTimeGraphView.this.getTraceMarkerList(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor()));
            this.applyResults(() -> {
                if (links != null) {
                    AbstractVirtualTimeGraphView.this.getTimeGraphViewer().setLinks(links);
                }
                AbstractVirtualTimeGraphView.this.getTimeGraphViewer().setMarkers(markers);
            });
            AbstractVirtualTimeGraphView.this.refresh();
        }

        private @NonNull Iterable<ITimeGraphEntry> filterEntries(@NonNull Set<ITimeGraphEntry> visibleEntries, VirtualTimeGraphEntry.Sampling sampling) {
            ArrayList<ITimeGraphEntry> filter = new ArrayList<ITimeGraphEntry>(visibleEntries.size());
            for (ITimeGraphEntry entry : visibleEntries) {
                if (entry instanceof VirtualTimeGraphEntry) {
                    VirtualTimeGraphEntry virtual = (VirtualTimeGraphEntry)entry;
                    if (sampling.equals(virtual.getSampling())) continue;
                    filter.add(virtual);
                    continue;
                }
                if (!(entry instanceof TimeGraphEntry) || !entry.hasTimeEvents()) continue;
                filter.add(entry);
            }
            return filter;
        }

        private List<ILinkEvent> getLinks(@NonNull VirtualTimeGraphEntry.Sampling sampling) {
            if (Objects.equals(sampling, AbstractVirtualTimeGraphView.this.fLastSampling)) {
                return AbstractVirtualTimeGraphView.this.fLinkCache;
            }
            List<@NonNull ILinkEvent> links = AbstractVirtualTimeGraphView.this.getLinkList(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor());
            if (!this.getMonitor().isCanceled()) {
                AbstractVirtualTimeGraphView.this.fLinkCache = links;
                AbstractVirtualTimeGraphView.this.fLastSampling = sampling;
            }
            return links;
        }
    }
}

