/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.layout.absolute.actions;

import java.util.Collections;
import java.util.Comparator;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.actions.AbstractAlignmentActionsSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleAlignmentActionsSupport<C extends IAbstractComponentInfo>
extends AbstractAlignmentActionsSupport<C> {
    @Override
    protected void commandAlignLeft() throws Exception {
        IAbstractComponentInfo target = (IAbstractComponentInfo)this.m_components.get(0);
        Rectangle targetBounds = this.getModelBounds(target);
        Point targetLocationInRoot = this.mapToRoot(target, targetBounds.x, targetBounds.y);
        for (IAbstractComponentInfo component : this.m_components) {
            if (target == component) continue;
            Rectangle objectBounds = this.getModelBounds(component);
            int x = this.mapFromRoot(component, (int)targetLocationInRoot.x, (int)0).x;
            this.commandChangeBounds(component, new Point(x, objectBounds.y), null);
        }
    }

    @Override
    protected void commandAlignRight() throws Exception {
        IAbstractComponentInfo target = (IAbstractComponentInfo)this.m_components.get(0);
        Rectangle targetBounds = this.getModelBounds(target);
        Point targetLocationInRoot = this.mapToRoot(target, targetBounds.x, targetBounds.y);
        for (IAbstractComponentInfo component : this.m_components) {
            if (target == component) continue;
            Rectangle objectBounds = this.getModelBounds(component);
            int r = this.mapFromRoot(component, (int)(targetLocationInRoot.x + targetBounds.width), (int)0).x;
            this.commandChangeBounds(component, new Point(r - objectBounds.width, objectBounds.y), null);
        }
    }

    @Override
    protected void commandAlignCenterHorizontally() throws Exception {
        IAbstractComponentInfo target = (IAbstractComponentInfo)this.m_components.get(0);
        Rectangle targetBounds = this.getModelBounds(target);
        Point targetLocationInRoot = this.mapToRoot(target, targetBounds.x, targetBounds.y);
        for (IAbstractComponentInfo component : this.m_components) {
            if (target == component) continue;
            Rectangle objectBounds = this.getModelBounds(component);
            int c = this.mapFromRoot(component, (int)(targetLocationInRoot.x + targetBounds.width / 2), (int)0).x;
            this.commandChangeBounds(component, new Point(c - objectBounds.width / 2, objectBounds.y), null);
        }
    }

    @Override
    protected void commandAlignTop() throws Exception {
        IAbstractComponentInfo target = (IAbstractComponentInfo)this.m_components.get(0);
        Rectangle targetBounds = this.getModelBounds(target);
        Point targetLocationInRoot = this.mapToRoot(target, targetBounds.x, targetBounds.y);
        for (IAbstractComponentInfo component : this.m_components) {
            if (target == component) continue;
            Rectangle objectBounds = this.getModelBounds(component);
            int y = this.mapFromRoot(component, (int)0, (int)targetLocationInRoot.y).y;
            this.commandChangeBounds(component, new Point(objectBounds.x, y), null);
        }
    }

    @Override
    protected void commandAlignBottom() throws Exception {
        IAbstractComponentInfo target = (IAbstractComponentInfo)this.m_components.get(0);
        Rectangle targetBounds = this.getModelBounds(target);
        Point targetLocationInRoot = this.mapToRoot(target, targetBounds.x, targetBounds.y);
        for (IAbstractComponentInfo component : this.m_components) {
            if (target == component) continue;
            Rectangle objectBounds = this.getModelBounds(component);
            int b = this.mapFromRoot(component, (int)0, (int)(targetLocationInRoot.y + targetBounds.height)).y;
            this.commandChangeBounds(component, new Point(objectBounds.x, b - objectBounds.height), null);
        }
    }

    @Override
    protected void commandAlignCenterVertically() throws Exception {
        IAbstractComponentInfo target = (IAbstractComponentInfo)this.m_components.get(0);
        Rectangle targetBounds = this.getModelBounds(target);
        Point targetLocationInRoot = this.mapToRoot(target, targetBounds.x, targetBounds.y);
        for (IAbstractComponentInfo component : this.m_components) {
            if (target == component) continue;
            Rectangle objectBounds = this.getModelBounds(component);
            int c = this.mapFromRoot(component, (int)0, (int)(targetLocationInRoot.y + targetBounds.height / 2)).y;
            this.commandChangeBounds(component, new Point(objectBounds.x, c - objectBounds.height / 2), null);
        }
    }

    @Override
    protected void commandDistributeSpaceVertically() throws Exception {
        int y;
        int space;
        Rectangle clientArea = this.getModelBounds(this.getLayoutContainer());
        int objectsHeight = 0;
        for (IAbstractComponentInfo component : this.m_components) {
            objectsHeight += this.getModelBounds(component).height;
        }
        Collections.sort(this.m_components, new Comparator<C>(){

            @Override
            public int compare(C component1, C component2) {
                return ((SimpleAlignmentActionsSupport)SimpleAlignmentActionsSupport.this).getModelBounds(component1).y - ((SimpleAlignmentActionsSupport)SimpleAlignmentActionsSupport.this).getModelBounds(component2).y;
            }
        });
        int componentsLength = this.m_components.size();
        if (DesignerPlugin.isCtrlPressed() && componentsLength > 2) {
            Rectangle topBounds = this.getModelBounds((IAbstractComponentInfo)this.m_components.get(0));
            Rectangle bottomBounds = this.getModelBounds((IAbstractComponentInfo)this.m_components.get(componentsLength - 1));
            int totalHeight = bottomBounds.bottom() - topBounds.y;
            space = (totalHeight - objectsHeight) / (componentsLength - 1);
            y = topBounds.y;
        } else {
            y = space = (clientArea.height - objectsHeight) / (componentsLength + 1);
        }
        for (IAbstractComponentInfo component : this.m_components) {
            Rectangle objectBounds = this.getModelBounds(component);
            this.commandChangeBounds(component, new Point(objectBounds.x, y), null);
            y += objectBounds.height;
            y += space;
        }
    }

    @Override
    protected void commandDistributeSpaceHorizontally() throws Exception {
        int x;
        int space;
        Rectangle clientArea = this.getModelBounds(this.getLayoutContainer());
        int objectsWidth = 0;
        for (IAbstractComponentInfo component : this.m_components) {
            objectsWidth += this.getModelBounds(component).width;
        }
        Collections.sort(this.m_components, new Comparator<C>(){

            @Override
            public int compare(C component1, C component2) {
                return ((SimpleAlignmentActionsSupport)SimpleAlignmentActionsSupport.this).getModelBounds(component1).x - ((SimpleAlignmentActionsSupport)SimpleAlignmentActionsSupport.this).getModelBounds(component2).x;
            }
        });
        int componentsLength = this.m_components.size();
        if (DesignerPlugin.isCtrlPressed() && componentsLength > 2) {
            Rectangle leftBounds = this.getModelBounds((IAbstractComponentInfo)this.m_components.get(0));
            Rectangle rightBounds = this.getModelBounds((IAbstractComponentInfo)this.m_components.get(componentsLength - 1));
            int totalWidth = rightBounds.right() - leftBounds.x;
            space = (totalWidth - objectsWidth) / (componentsLength - 1);
            x = leftBounds.x;
        } else {
            x = space = (clientArea.width - objectsWidth) / (componentsLength + 1);
        }
        for (IAbstractComponentInfo component : this.m_components) {
            Rectangle objectBounds = this.getModelBounds(component);
            this.commandChangeBounds(component, new Point(x, objectBounds.y), null);
            x += objectBounds.width;
            x += space;
        }
    }

    @Override
    protected void commandCenterVertically() throws Exception {
        Rectangle clientArea = this.getModelBounds(this.getLayoutContainer());
        int clientHeight = clientArea.height;
        for (IAbstractComponentInfo component : this.m_components) {
            Rectangle objectBounds = this.getModelBounds(component);
            this.commandChangeBounds(component, new Point(objectBounds.x, (clientHeight - objectBounds.height) / 2), null);
        }
    }

    @Override
    protected void commandCenterHorizontally() throws Exception {
        IAbstractComponentInfo container = this.getLayoutContainer();
        int clientAreaWidth = container.getBounds().width - container.getClientAreaInsets().getWidth();
        for (IAbstractComponentInfo component : this.m_components) {
            Rectangle objectBounds = this.getModelBounds(component);
            int newX = (clientAreaWidth - objectBounds.width) / 2;
            this.commandChangeBounds(component, new Point(newX, objectBounds.y), null);
        }
    }

    @Override
    protected void commandReplicateHeight() throws Exception {
        IAbstractComponentInfo target = (IAbstractComponentInfo)this.m_components.get(0);
        Rectangle targetBounds = this.getModelBounds(target);
        for (IAbstractComponentInfo component : this.m_components) {
            if (target == component) continue;
            Rectangle objectBounds = this.getModelBounds(component);
            this.commandChangeBounds(component, null, new Dimension(objectBounds.width, targetBounds.height));
        }
    }

    @Override
    protected void commandReplicateWidth() throws Exception {
        IAbstractComponentInfo target = (IAbstractComponentInfo)this.m_components.get(0);
        Rectangle targetBounds = this.getModelBounds(target);
        for (IAbstractComponentInfo component : this.m_components) {
            if (target == component) continue;
            Rectangle objectBounds = this.getModelBounds(component);
            this.commandChangeBounds(component, null, new Dimension(targetBounds.width, objectBounds.height));
        }
    }

    protected abstract void commandChangeBounds(C var1, Point var2, Dimension var3) throws Exception;

    private Rectangle getModelBounds(C component) {
        return component.getModelBounds();
    }

    private Point mapToRoot(C component, int x, int y) {
        IAbstractComponentInfo parent = (IAbstractComponentInfo)((Object)component.getParent());
        while (parent.getParent() != null) {
            if (this.isValidObjectOnRootPath(parent)) {
                Rectangle bounds = this.getModelBounds(parent);
                x += bounds.x;
                y += bounds.y;
            }
            parent = (IAbstractComponentInfo)((Object)parent.getParent());
        }
        return new Point(x, y);
    }

    private Point mapFromRoot(C component, int x, int y) {
        IAbstractComponentInfo parent = (IAbstractComponentInfo)((Object)component.getParent());
        while (parent.getParent() != null) {
            if (this.isValidObjectOnRootPath(parent)) {
                Rectangle bounds = this.getModelBounds(parent);
                x -= bounds.x;
                y -= bounds.y;
            }
            parent = (IAbstractComponentInfo)((Object)parent.getParent());
        }
        return new Point(x, y);
    }

    protected abstract boolean isValidObjectOnRootPath(IAbstractComponentInfo var1);
}

