/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import java.text.MessageFormat;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractTextPropertyEditor;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

public final class IntegerArrayPropertyEditor
extends AbstractTextPropertyEditor {
    public static final IntegerArrayPropertyEditor INSTANCE = new IntegerArrayPropertyEditor();

    private IntegerArrayPropertyEditor() {
    }

    public String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value instanceof int[]) {
            int[] array = (int[])value;
            return StringUtils.join((Object[])ArrayUtils.toObject((int[])array), (char)' ');
        }
        return null;
    }

    protected String getEditorText(Property property) throws Exception {
        return this.getText(property);
    }

    protected boolean setEditorText(Property property, String text) throws Exception {
        int[] array;
        if ((text = text.trim()).length() == 0) {
            property.setValue(Property.UNKNOWN_VALUE);
            return true;
        }
        try {
            String[] parts = StringUtils.split((String)text);
            array = new int[parts.length];
            int i = 0;
            while (i < parts.length) {
                String part = parts[i];
                array[i] = Integer.valueOf(part);
                ++i;
            }
        }
        catch (Throwable throwable) {
            UiUtils.openWarning(DesignerPlugin.getShell(), property.getTitle(), MessageFormat.format(ModelMessages.IntegerPropertyEditor_notValidInt, text));
            return false;
        }
        property.setValue(array);
        return true;
    }
}

