/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.profiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.xtend.profiler.profilermodel.CallGroup;
import org.eclipse.xtend.profiler.profilermodel.Cycle;
import org.eclipse.xtend.profiler.profilermodel.Item;
import org.eclipse.xtend.profiler.profilermodel.ModelFactory;
import org.eclipse.xtend.profiler.profilermodel.ProfilingResult;

public class CycleDetector {
    private final ProfilingResult profilingResult;
    List<Item> visited = new ArrayList<Item>();
    List<Item> stack = new ArrayList<Item>();
    Map<Item, Integer> lowLink = new HashMap<Item, Integer>();

    public CycleDetector(ProfilingResult result) {
        this.profilingResult = result;
    }

    private void tarjan(Item item) {
        this.visited.add(item);
        this.setLowLink(item, this.getIndex(item));
        this.stack.add(0, item);
        for (CallGroup group : item.getSubroutines()) {
            Item sub = group.getSubroutine();
            if (!this.hasBeenVisited(sub)) {
                this.tarjan(sub);
                this.setLowLinkIfSmaller(item, this.getLowLink(sub));
                continue;
            }
            if (!this.stack.contains(sub)) continue;
            this.setLowLinkIfSmaller(item, this.getIndex(sub));
        }
        if (this.getLowLink(item) == this.getIndex(item)) {
            this.buildCycleFromStack(item);
        }
    }

    private void buildCycleFromStack(Item item) {
        Item v;
        ArrayList<Item> items = new ArrayList<Item>();
        do {
            v = this.stack.remove(0);
            items.add(0, v);
        } while (!item.equals(v));
        if (items.size() > 1 || this.isSelfRecursion(item)) {
            Cycle cycle = ModelFactory.eINSTANCE.createCycle();
            cycle.getItems().addAll(items);
            this.profilingResult.getCycles().add(0, (Object)cycle);
        }
    }

    private boolean isSelfRecursion(Item item) {
        for (CallGroup g : item.getSubroutines()) {
            if (!item.equals(g.getSubroutine())) continue;
            return true;
        }
        return false;
    }

    public void detectCycles() {
        this.profilingResult.getCycles().clear();
        LinkedHashSet<Item> toBeVisited = new LinkedHashSet<Item>((Collection<Item>)this.profilingResult.getItems());
        while (!toBeVisited.isEmpty()) {
            Item item = (Item)toBeVisited.iterator().next();
            this.tarjan(item);
            toBeVisited.removeAll(this.visited);
        }
    }

    private void setLowLink(Item item, int value) {
        this.lowLink.put(item, value);
    }

    private void setLowLinkIfSmaller(Item item, int potentiallySmallerValue) {
        this.setLowLink(item, Math.min(this.getLowLink(item), potentiallySmallerValue));
    }

    private int getLowLink(Item item) {
        return this.lowLink.get(item);
    }

    private boolean hasBeenVisited(Item item) {
        return this.visited.contains(item);
    }

    private int getIndex(Item item) {
        if (!this.hasBeenVisited(item)) {
            throw new IllegalStateException("Item has not been visited, yet.");
        }
        return this.visited.indexOf(item);
    }
}

