/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FontUnderline;
import org.apache.poi.ss.usermodel.Workbook;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.value.ListValue;
import org.eclipse.birt.report.engine.css.engine.value.StringValue;
import org.w3c.dom.css.CSSValue;
import uk.co.spudsoft.birt.emitters.excel.BirtStyle;
import uk.co.spudsoft.birt.emitters.excel.StyleManagerUtils;

public class FontManager {
    private Workbook workbook;
    private StyleManagerUtils smu;
    private List<FontPair> fonts = new ArrayList<FontPair>();
    private Font defaultFont = null;
    private CSSEngine cssEngine;
    static int[] COMPARE_CSS_PROPERTIES;

    static {
        int[] nArray = new int[6];
        nArray[0] = 55;
        nArray[1] = 39;
        nArray[2] = 29;
        nArray[3] = 40;
        nArray[4] = 58;
        COMPARE_CSS_PROPERTIES = nArray;
    }

    public FontManager(CSSEngine cssEngine, Workbook workbook, StyleManagerUtils smu) {
        this.cssEngine = cssEngine;
        this.workbook = workbook;
        this.smu = smu;
    }

    CSSEngine getCssEngine() {
        return this.cssEngine;
    }

    private static String cleanupQuotes(CSSValue value) {
        String stringValue;
        ListValue listValue;
        if (value == null) {
            return null;
        }
        if (value instanceof ListValue && (listValue = (ListValue)value).getLength() > 0) {
            value = listValue.item(0);
        }
        String string = stringValue = value instanceof StringValue ? ((StringValue)value).getStringValue() : value.getCssText();
        if (stringValue == null || stringValue.isEmpty()) {
            return stringValue;
        }
        if (stringValue.startsWith("\"") && stringValue.endsWith("\"")) {
            String newFamily = stringValue.substring(1, stringValue.length() - 1);
            return newFamily;
        }
        return stringValue;
    }

    public static boolean fontsEquivalent(BirtStyle style1, BirtStyle style2) {
        int i = 0;
        while (i < COMPARE_CSS_PROPERTIES.length) {
            CSSValue value2;
            int prop = COMPARE_CSS_PROPERTIES[i];
            CSSValue value1 = style1.getProperty(prop);
            if (!StyleManagerUtils.objectsEqual(value1, value2 = style2.getProperty(prop))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Font createFont(BirtStyle birtStyle) {
        String fontUnderline;
        String fontStyle;
        short fontWeight;
        Font font = this.workbook.createFont();
        String fontName = this.smu.poiFontNameFromBirt(FontManager.cleanupQuotes(birtStyle.getProperty(55)));
        if (fontName == null) {
            fontName = "Calibri";
        }
        font.setFontName(fontName);
        short fontSize = this.smu.fontSizeInPoints(FontManager.cleanupQuotes(birtStyle.getProperty(39)));
        if (fontSize > 0) {
            font.setFontHeightInPoints(fontSize);
        }
        if ((fontWeight = this.smu.poiFontWeightFromBirt(FontManager.cleanupQuotes(birtStyle.getProperty(29)))) > 0) {
            font.setBoldweight(fontWeight);
        }
        if ("italic".equals(fontStyle = FontManager.cleanupQuotes(birtStyle.getProperty(40))) || "oblique".equals(fontStyle)) {
            font.setItalic(true);
        }
        if ("underline".equals(fontUnderline = FontManager.cleanupQuotes(birtStyle.getProperty(58)))) {
            font.setUnderline(FontUnderline.SINGLE.getByteValue());
        }
        this.smu.addColourToFont(this.workbook, font, FontManager.cleanupQuotes(birtStyle.getProperty(0)));
        this.fonts.add(new FontPair(birtStyle, font));
        return font;
    }

    private Font getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.workbook.createFont();
            this.defaultFont.setFontName("Calibri");
            this.defaultFont.setFontHeightInPoints((short)11);
        }
        return this.defaultFont;
    }

    public Font getFont(BirtStyle birtStyle) {
        if (birtStyle == null) {
            return this.getDefaultFont();
        }
        if (birtStyle.getProperty(55) == null && birtStyle.getProperty(39) == null && birtStyle.getProperty(29) == null && birtStyle.getProperty(40) == null && birtStyle.getProperty(58) == null && birtStyle.getProperty(0) == null) {
            return this.getDefaultFont();
        }
        for (FontPair fontPair : this.fonts) {
            if (!FontManager.fontsEquivalent(birtStyle, fontPair.birtStyle)) continue;
            return fontPair.poiFont;
        }
        return this.createFont(birtStyle);
    }

    private BirtStyle birtStyleFromFont(Font source) {
        for (FontPair fontPair : this.fonts) {
            if (!source.equals(fontPair.poiFont)) continue;
            return fontPair.birtStyle.clone();
        }
        return new BirtStyle(this.cssEngine);
    }

    public Font getFontWithExtraStyle(Font source, IStyle birtExtraStyle) {
        BirtStyle birtStyle = this.birtStyleFromFont(source);
        int i = 0;
        while (i < 61) {
            CSSValue value = birtExtraStyle.getProperty(i);
            if (value != null) {
                birtStyle.setProperty(i, value);
            }
            ++i;
        }
        Font newFont = this.getFont(birtStyle);
        return newFont;
    }

    private class FontPair {
        public BirtStyle birtStyle;
        public Font poiFont;

        public FontPair(BirtStyle birtStyle, Font poiFont) {
            this.birtStyle = birtStyle;
            this.poiFont = poiFont;
        }
    }
}

