/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.examples.adesigner.eval.odf;

import java.util.HashSet;
import java.util.List;
import org.eclipse.actf.examples.adesigner.eval.odf.OdfCheckerEngineImpl;
import org.eclipse.actf.examples.adesigner.eval.odf.OdfCheckerPlugin;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.visualization.eval.ICheckTarget;
import org.eclipse.actf.visualization.eval.IChecker;
import org.eclipse.actf.visualization.eval.IEvaluationItem;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfChecker
implements IChecker {
    private IPreferenceStore store = OdfCheckerPlugin.getDefault().getPreferenceStore();
    private HashSet<String> mimeSet = new HashSet();

    public OdfChecker() {
        String[] stringArray = IModelService.MIMETYPES_ODF;
        int n = IModelService.MIMETYPES_ODF.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.mimeSet.add(string);
            ++n2;
        }
    }

    public List<IProblemItem> check(ICheckTarget iCheckTarget) {
        OdfCheckerEngineImpl odfCheckerEngineImpl = new OdfCheckerEngineImpl(iCheckTarget.getTargetDocument(), iCheckTarget.getAdditionalDocument("html"));
        odfCheckerEngineImpl.setDetectOdfVersion(this.store.getBoolean("odfPlugin.optins.detectVersion"));
        return odfCheckerEngineImpl.check();
    }

    public boolean isTargetFormat(String string) {
        if (string == null) {
            return false;
        }
        return this.mimeSet.contains(string);
    }

    public boolean isEnabled() {
        IEvaluationItem iEvaluationItem = GuidelineHolder.getInstance().getEvaluationItem("O_999000001");
        return iEvaluationItem != null && GuidelineHolder.getInstance().isMatchedCheckItem(iEvaluationItem);
    }
}

