/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.StringHelper;
import org.eclipse.amalgam.explorer.activity.ui.internal.util.ActivityExplorerLoggerService;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;

public class CloneDiagramCommand
extends AbstractCommand {
    private Collection<DRepresentationDescriptor> _representationDescriptors;
    private Collection<DRepresentation> _clones;
    private Collection<ICloneListener> _listeners;

    public CloneDiagramCommand(Collection<DRepresentationDescriptor> representations_p) {
        super(Messages.CloneDiagramCommand_0);
        this._representationDescriptors = representations_p;
    }

    public void dispose() {
        super.dispose();
        if (this._clones != null) {
            this._clones.clear();
            this._clones = null;
        }
        if (this._listeners != null) {
            this._listeners.clear();
            this._listeners = null;
        }
        if (this._representationDescriptors != null) {
            this._representationDescriptors = null;
        }
    }

    public void addCloneListener(ICloneListener listener_p) {
        if (listener_p == null) {
            return;
        }
        if (this._listeners == null) {
            this._listeners = new HashSet<ICloneListener>(1);
        }
        this._listeners.add(listener_p);
    }

    public void removeCloneListener(ICloneListener listener_p) {
        if (this._listeners == null || listener_p == null) {
            return;
        }
        this._listeners.remove(listener_p);
    }

    protected void notifyListeners(EventType type_p, DRepresentation clone_p, Session session_p) {
        if (this._listeners == null || this._listeners.isEmpty()) {
            return;
        }
        ArrayList<ICloneListener> listeners = new ArrayList<ICloneListener>(this._listeners);
        for (ICloneListener listener : listeners) {
            try {
                if (EventType.ADD.equals((Object)type_p)) {
                    listener.cloneCreated(clone_p, session_p);
                    continue;
                }
                if (!EventType.REMOVE.equals((Object)type_p)) continue;
                listener.cloneAboutToBeRemoved(clone_p, session_p);
            }
            catch (Exception exception_p) {
                ActivityExplorerLoggerService.getInstance().log(4, "Unable to notify listeners !", exception_p);
            }
        }
    }

    public boolean canUndo() {
        return this._clones != null && this._clones.size() > 0;
    }

    public void execute() {
        if (this._clones == null) {
            this._clones = new ArrayList<DRepresentation>(0);
        } else if (this._clones.size() > 0) {
            this._clones.clear();
        }
        for (DRepresentationDescriptor representationDescriptor : this._representationDescriptors) {
            DRepresentation representation = representationDescriptor.getRepresentation();
            if (representation instanceof DSemanticDecorator) {
                EObject target = ((DSemanticDecorator)representation).getTarget();
                Session session = SessionManager.INSTANCE.getSession(target);
                DRepresentation copyRepresentation = DialectManager.INSTANCE.copyRepresentation(representation, this.getCloneName(representation, session), session, null);
                this._clones.add(copyRepresentation);
                continue;
            }
            ActivityExplorerActivator.getDefault().getLog().log((IStatus)new Status(2, ActivityExplorerActivator.ID, "Clone is not supported for " + representationDescriptor.getName()));
        }
    }

    protected String getCloneName(DRepresentation representation_p, Session session_p) {
        String message = "Clone {0}of {1}";
        String cloneName = StringHelper.formatMessage(message, new Object[]{"", representation_p.getName()});
        boolean cloneNameFound = false;
        Collection allRepresentations = DialectManager.INSTANCE.getAllRepresentations(session_p);
        int i = 1;
        while (!cloneNameFound) {
            boolean collision = false;
            for (DRepresentation representation : allRepresentations) {
                if (!cloneName.equals(representation.getName())) continue;
                collision = true;
                break;
            }
            if (collision) {
                cloneName = StringHelper.formatMessage(message, new Object[]{"" + ++i + ' ', representation_p.getName()});
            }
            boolean bl = cloneNameFound = !collision;
        }
        return cloneName;
    }

    protected boolean prepare() {
        return true;
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        for (DRepresentation representation : this._clones) {
            Session session = SessionManager.INSTANCE.getSession(((DSemanticDecorator)representation).getTarget());
            RepresentationDescription dRepresentationDescription = DialectManager.INSTANCE.getDescription(representation);
            Collection representationDescriptors = DialectManager.INSTANCE.getRepresentationDescriptors(dRepresentationDescription, session);
            for (DRepresentationDescriptor dRepresentationDescriptor : representationDescriptors) {
                if (!dRepresentationDescription.getName().equals(representation.getName())) continue;
                DialectManager.INSTANCE.deleteRepresentation(dRepresentationDescriptor, session);
            }
        }
        this._clones.clear();
    }

    protected static enum EventType {
        ADD,
        REMOVE;

    }

    public static interface ICloneListener {
        public void cloneCreated(DRepresentation var1, Session var2);

        public void cloneAboutToBeRemoved(DRepresentation var1, Session var2);
    }
}

