/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.model;

import java.text.MessageFormat;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.Messages;

public class Problem
implements IProblem {
    static int ID = 1;
    Map<String, Object> mMap = new TreeMap<String, Object>();
    final long mCreated = System.currentTimeMillis();
    final long mId = ID++;
    Object fContext = null;

    public Problem() {
    }

    public Problem(Object context) {
        this.fContext = context;
    }

    @Override
    public <T> T getAttribute(String attributeName) {
        Object value = this.mMap.get(attributeName);
        return (T)value;
    }

    @Override
    public <T> T getAttribute(String attributeName, T defaultValue) {
        Object value = this.mMap.get(attributeName);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    @Override
    public <T> void setAttribute(String attributeName, T value) {
        this.mMap.put(attributeName, value);
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        this.mMap.clear();
        this.mMap.putAll(attributes);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.mMap;
    }

    @Override
    public long getCreationTime() {
        return this.mCreated;
    }

    @Override
    public long getId() {
        return this.mId;
    }

    @Override
    public void fill(String msgId, Object ... args) {
        String key = msgId;
        int i = 0;
        while (i < args.length) {
            args[i] = this.asArg(args[i]);
            ++i;
        }
        this.setAttribute("message.id", msgId);
        this.setAttribute("message.args", args);
        String msgDef = Messages.missingKey(key);
        String msg = this.getMessage(key, msgDef);
        try {
            this.setAttribute("message", MessageFormat.format(msg, args));
        }
        catch (Throwable t) {
            this.setAttribute("message", MessageFormat.format(msgDef, t, t.getCause()));
        }
        key = String.valueOf(msgId) + ".fix";
        msg = this.getMessage(key, null);
        if (msg != null) {
            try {
                this.setAttribute("fixMessage", MessageFormat.format(msg, args));
            }
            catch (Throwable t) {
                this.setAttribute("fixMessage", MessageFormat.format(Messages.missingKey(key), t, t.getCause()));
            }
        }
    }

    Object asArg(Object o) {
        String v;
        if (o == null) {
            return null;
        }
        if (o.getClass().isArray()) {
            StringBuilder sb = new StringBuilder("{");
            Object[] oa = (Object[])o;
            int j = 0;
            while (j < oa.length) {
                sb.append(oa[j]);
                if (j + 1 < oa.length) {
                    sb.append(",");
                }
                ++j;
            }
            sb.append("}");
            return sb.toString();
        }
        if (o.getClass() == String.class && (v = (String)o).startsWith("text.")) {
            return this.getMessage(v, v);
        }
        return o;
    }

    String getMessage(String key, String def) {
        if (this.fContext == null) {
            return def;
        }
        Class<?> clazz = this.fContext.getClass();
        do {
            String bundleName;
            Messages msg;
            if (!(msg = Messages.getMessages(bundleName = String.valueOf(clazz.getPackage().getName()) + ".messages")).containsKey(key)) continue;
            if (!this.mMap.containsKey("bundle.clazz")) {
                this.mMap.put("bundle.clazz", clazz);
                this.mMap.put("bundleName", bundleName);
            }
            return msg.get(key);
        } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
        return def;
    }
}

