/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import com.google.common.base.Preconditions;
import java.net.URL;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.console.ProcessDescription;
import org.eclipse.buildship.core.event.Event;
import org.eclipse.buildship.core.event.EventListener;
import org.eclipse.buildship.core.scan.BuildScanCreatedEvent;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.PlatformUI;

public final class OpenBuildScanAction
extends Action
implements EventListener {
    private final ProcessDescription processDescription;
    private String buildScanUrl;

    public OpenBuildScanAction(ProcessDescription processDescription) {
        this.processDescription = (ProcessDescription)Preconditions.checkNotNull((Object)processDescription);
        this.setToolTipText("Open Build Scan");
        this.setImageDescriptor(PluginImages.BUILD_SCAN.withState(PluginImage.ImageState.ENABLED).getImageDescriptor());
        this.setDisabledImageDescriptor(PluginImages.BUILD_SCAN.withState(PluginImage.ImageState.DISABLED).getImageDescriptor());
        this.setEnabled(false);
        CorePlugin.listenerRegistry().addEventListener((EventListener)this);
    }

    public void onEvent(Event event) {
        BuildScanCreatedEvent buildScanEvent;
        if (event instanceof BuildScanCreatedEvent && (buildScanEvent = (BuildScanCreatedEvent)event).getProcessDescription().equals(this.processDescription)) {
            this.buildScanUrl = buildScanEvent.getBuildScanUrl();
            this.setEnabled(true);
        }
    }

    public void run() {
        try {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(this.buildScanUrl));
        }
        catch (Exception e) {
            CorePlugin.logger().warn("Cannot open " + this.buildScanUrl + " in external browser", (Throwable)e);
        }
    }

    public void dispose() {
        CorePlugin.listenerRegistry().removeEventListener((EventListener)this);
    }
}

