/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.decorators;

import java.io.IOException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.ui.Activator;
import org.eclipse.egit.gitflow.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.PlatformUI;

public class GitFlowLightweightDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String DECORATOR_ID = "org.eclipse.egit.gitflow.ui.internal.decorators.GitflowLightweightDecorator";
    private ILog log = Activator.getDefault().getLog();

    public void decorate(Object element, IDecoration decoration) {
        if (Activator.getDefault() == null) {
            return;
        }
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        GitFlowRepository repository = GitFlowLightweightDecorator.getRepository(element);
        try {
            if (repository != null) {
                this.decorateRepository(repository, decoration);
            }
        }
        catch (Exception e) {
            this.handleException(repository, e);
        }
    }

    @Nullable
    private static GitFlowRepository getRepository(Object element) {
        RepositoryNode node;
        Repository repo;
        GitFlowRepository repository = null;
        if (element instanceof GitFlowRepository) {
            repository = (GitFlowRepository)element;
        }
        if (element instanceof RepositoryNode && (repo = (Repository)(node = (RepositoryNode)element).getObject()) != null) {
            repository = new GitFlowRepository(repo);
        }
        return repository;
    }

    private void decorateRepository(GitFlowRepository repository, IDecoration decoration) throws IOException {
        DecorationHelper helper = new DecorationHelper();
        helper.decorate(decoration, repository);
    }

    private void handleException(GitFlowRepository repository, Exception e) {
        if (repository != null) {
            this.log.log(Activator.error(e.getMessage(), e));
        }
    }

    private static class DecorationHelper {
        private static final ImageDescriptor INITIALIZED_IMAGE = new CachedImageDescriptor(UIIcons.OVR_GITFLOW);

        private DecorationHelper() {
        }

        public void decorate(IDecoration decoration, GitFlowRepository repository) throws IOException {
            this.decorateIcons(decoration, repository);
        }

        private void decorateIcons(IDecoration decoration, GitFlowRepository repository) throws IOException {
            ImageDescriptor overlay = null;
            if (repository.getConfig().isInitialized()) {
                overlay = INITIALIZED_IMAGE;
            }
            decoration.addOverlay(overlay);
        }

        private static class CachedImageDescriptor
        extends ImageDescriptor {
            private ImageDescriptor descriptor;
            private ImageData data;

            public CachedImageDescriptor(ImageDescriptor descriptor) {
                this.descriptor = descriptor;
            }

            public ImageData getImageData() {
                if (this.data == null) {
                    this.data = this.descriptor.getImageData();
                }
                return this.data;
            }
        }
    }
}

