/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.svn.ext;

import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.connector.core.EMFDiffMergeCoreConnectorPlugin;
import org.eclipse.emf.diffmerge.connector.core.ext.AbstractURIConvertingScopeDefinitionFactory;
import org.eclipse.emf.diffmerge.connector.svn.Messages;
import org.eclipse.emf.diffmerge.connector.svn.ext.SVNHistoryURIConverter;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.ui.compare.ResourceCompareInput;

public class SVNRemoteScopeDefinitionFactory
extends AbstractURIConvertingScopeDefinitionFactory {
    protected URI convertToURI(Object entrypoint_p) {
        URI result = entrypoint_p instanceof ResourceCompareInput.ResourceElement ? this.getResourceElementURI((ResourceCompareInput.ResourceElement)entrypoint_p) : super.convertToURI(entrypoint_p);
        return result;
    }

    protected String getLabelFor(Object entrypoint_p) {
        ResourceCompareInput.ResourceElement res = (ResourceCompareInput.ResourceElement)entrypoint_p;
        SVNRevision rev = res.getRepositoryResource().getSelectedRevision();
        String result = null;
        try {
            String url = res.getRepositoryResource().getUrl();
            result = SVNRevision.BASE.equals((Object)rev) ? String.format(Messages.SVNRemoteScopeDefinitionFactory_LabelBase, url) : (SVNRevision.HEAD.equals((Object)rev) ? String.format(Messages.SVNRemoteScopeDefinitionFactory_LabelHead, url) : String.format(Messages.SVNRemoteScopeDefinitionFactory_LabelRev, url, Long.toString(res.getRepositoryResource().getRevision())));
        }
        catch (SVNConnectorException e) {
            EMFDiffMergeCoreConnectorPlugin.getDefault().logError((Exception)((Object)e));
        }
        if (result == null) {
            result = res.getName();
        }
        return result;
    }

    protected URI getResourceElementURI(ResourceCompareInput.ResourceElement resourceElement_p) {
        return URI.createURI((String)resourceElement_p.getRepositoryResource().getUrl());
    }

    protected InputStream getStream(Object entrypoint_p) throws CoreException {
        InputStream result = entrypoint_p instanceof ResourceCompareInput.ResourceElement ? ((ResourceCompareInput.ResourceElement)entrypoint_p).getContents() : super.getStream(entrypoint_p);
        return result;
    }

    protected URIConverter getURIConverter(Object entrypoint_p) {
        SVNHistoryURIConverter result = null;
        if (entrypoint_p instanceof ResourceCompareInput.ResourceElement) {
            ResourceCompareInput.ResourceElement res = (ResourceCompareInput.ResourceElement)entrypoint_p;
            result = new SVNHistoryURIConverter(res.getRepositoryResource().getRepositoryLocation(), res.getRepositoryResource().getSelectedRevision());
        }
        return result;
    }

    public boolean isApplicableTo(Object entrypoint_p) {
        return entrypoint_p instanceof ResourceCompareInput.ResourceElement && !((ResourceCompareInput.ResourceElement)entrypoint_p).isEditable();
    }
}

