/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.dsl.generator;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.parsley.dsl.jvmmodel.EmfParsleyDslGeneratorUtils;
import org.eclipse.emf.parsley.dsl.model.Module;
import org.eclipse.emf.parsley.dsl.model.PartSpecification;
import org.eclipse.emf.parsley.dsl.model.ViewSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class EmfParsleyDslPluginXmlGenerator
implements IGenerator {
    @Inject
    @Extension
    private EmfParsleyDslGeneratorUtils _emfParsleyDslGeneratorUtils;
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;

    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        Iterable _filter = Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)resource.getAllContents()), Module.class);
        for (Module module : _filter) {
            boolean _greaterThan;
            CharSequence contents = this.generatePluginXml(module);
            int _length = contents.length();
            boolean bl = _greaterThan = _length > 0;
            if (!_greaterThan) continue;
            String _replace = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)module).toString().replace(".", "/");
            String _plus = String.valueOf(_replace) + "/";
            String _plus_1 = String.valueOf(_plus) + "plugin.xml_emfparsley_gen";
            fsa.generateFile(_plus_1, contents);
        }
    }

    public CharSequence generatePluginXml(Module module) {
        boolean _not;
        CharSequence _xifexpression = null;
        boolean _shouldGenerateExtensions = this._emfParsleyDslGeneratorUtils.shouldGenerateExtensions(module);
        boolean bl = _not = !_shouldGenerateExtensions;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("<extension");
        _builder_1.newLine();
        _builder_1.append("      ");
        _builder_1.append("point=\"org.eclipse.ui.views\">");
        _builder_1.newLine();
        _builder_1.append("   ");
        Functions.Function1<PartSpecification, CharSequence> _function = new Functions.Function1<PartSpecification, CharSequence>(){

            public CharSequence apply(PartSpecification it) {
                return EmfParsleyDslPluginXmlGenerator.this.generateExtensionPoint(it);
            }
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(module.getPartsSpecifications().getParts(), (Functions.Function1)_function), (CharSequence)"");
        _builder_1.append(_join, "   ");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("</extension>");
        _builder_1.newLine();
        _xifexpression = this.generatePluginXml((CharSequence)_builder_1);
        return _xifexpression;
    }

    protected CharSequence _generateExtensionPoint(PartSpecification partSpecification) {
        return null;
    }

    protected CharSequence _generateExtensionPoint(ViewSpecification viewSpecification) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<view");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("category=\"");
        String _xifexpression = null;
        _xifexpression = viewSpecification.getCategory() == null || viewSpecification.getCategory().isEmpty() ? "org.eclipse.emf.parsley" : viewSpecification.getCategory();
        _builder.append(_xifexpression, "      ");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("class=\"");
        String _executableExtensionFactoryQN = this._emfParsleyDslGeneratorUtils.executableExtensionFactoryQN(viewSpecification);
        _builder.append(_executableExtensionFactoryQN, "      ");
        _builder.append(":");
        String _identifier = viewSpecification.getType().getIdentifier();
        _builder.append(_identifier, "      ");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("id=\"");
        String _id = viewSpecification.getId();
        _builder.append(_id, "      ");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("name=\"");
        String _viewName = viewSpecification.getViewName();
        _builder.append(_viewName, "      ");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("restorable=\"true\">");
        _builder.newLine();
        _builder.append("</view>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePluginXml(CharSequence contents) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append("<?eclipse version=\"3.4\"?>");
        _builder.newLine();
        _builder.append("<plugin>");
        _builder.newLine();
        _builder.append("   ");
        _builder.append((Object)contents, "   ");
        _builder.newLineIfNotEmpty();
        _builder.append("</plugin>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateExtensionPoint(PartSpecification viewSpecification) {
        if (viewSpecification instanceof ViewSpecification) {
            return this._generateExtensionPoint((ViewSpecification)viewSpecification);
        }
        if (viewSpecification != null) {
            return this._generateExtensionPoint(viewSpecification);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(viewSpecification).toString());
    }
}

