/*
* generated by Xtext
*/
package org.eclipse.gef.dot.internal.language.services;

import com.google.inject.Singleton;
import com.google.inject.Inject;

import java.util.List;

import org.eclipse.xtext.*;
import org.eclipse.xtext.service.GrammarProvider;
import org.eclipse.xtext.service.AbstractElementFinder.*;


@Singleton
public class DotHtmlLabelGrammarAccess extends AbstractGrammarElementFinder {
	
	
	public class HtmlLabelElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "HtmlLabel");
		private final Assignment cPartsAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cPartsHtmlContentParserRuleCall_0 = (RuleCall)cPartsAssignment.eContents().get(0);
		
		/// * 
		// * This grammar comes with a custom lexer to scan HTML-like labels. Such a label is surrounded
		// * by angle brackets ('<' and '>') in the host Dot language. However, this grammar is used to
		// * analyze the contents of such strings.
		// * / HtmlLabel:
		//	parts+=HtmlContent*;
		public ParserRule getRule() { return rule; }

		//parts+=HtmlContent*
		public Assignment getPartsAssignment() { return cPartsAssignment; }

		//HtmlContent
		public RuleCall getPartsHtmlContentParserRuleCall_0() { return cPartsHtmlContentParserRuleCall_0; }
	}

	public class HtmlContentElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "HtmlContent");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Assignment cTagAssignment_0 = (Assignment)cAlternatives.eContents().get(0);
		private final RuleCall cTagHtmlTagParserRuleCall_0_0 = (RuleCall)cTagAssignment_0.eContents().get(0);
		private final Assignment cTextAssignment_1 = (Assignment)cAlternatives.eContents().get(1);
		private final RuleCall cTextTEXTTerminalRuleCall_1_0 = (RuleCall)cTextAssignment_1.eContents().get(0);
		
		//HtmlContent:
		//	tag=HtmlTag | text=TEXT;
		public ParserRule getRule() { return rule; }

		//tag=HtmlTag | text=TEXT
		public Alternatives getAlternatives() { return cAlternatives; }

		//tag=HtmlTag
		public Assignment getTagAssignment_0() { return cTagAssignment_0; }

		//HtmlTag
		public RuleCall getTagHtmlTagParserRuleCall_0_0() { return cTagHtmlTagParserRuleCall_0_0; }

		//text=TEXT
		public Assignment getTextAssignment_1() { return cTextAssignment_1; }

		//TEXT
		public RuleCall getTextTEXTTerminalRuleCall_1_0() { return cTextTEXTTerminalRuleCall_1_0; }
	}

	public class HtmlTagElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "HtmlTag");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final RuleCall cTAG_STARTTerminalRuleCall_0 = (RuleCall)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Assignment cAttributesAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cAttributesHtmlAttrParserRuleCall_2_0 = (RuleCall)cAttributesAssignment_2.eContents().get(0);
		private final Alternatives cAlternatives_3 = (Alternatives)cGroup.eContents().get(3);
		private final Assignment cSelfClosingAssignment_3_0 = (Assignment)cAlternatives_3.eContents().get(0);
		private final RuleCall cSelfClosingTAG_END_CLOSETerminalRuleCall_3_0_0 = (RuleCall)cSelfClosingAssignment_3_0.eContents().get(0);
		private final Group cGroup_3_1 = (Group)cAlternatives_3.eContents().get(1);
		private final RuleCall cTAG_ENDTerminalRuleCall_3_1_0 = (RuleCall)cGroup_3_1.eContents().get(0);
		private final Assignment cChildrenAssignment_3_1_1 = (Assignment)cGroup_3_1.eContents().get(1);
		private final RuleCall cChildrenHtmlContentParserRuleCall_3_1_1_0 = (RuleCall)cChildrenAssignment_3_1_1.eContents().get(0);
		private final RuleCall cTAG_START_CLOSETerminalRuleCall_3_1_2 = (RuleCall)cGroup_3_1.eContents().get(2);
		private final Assignment cCloseNameAssignment_3_1_3 = (Assignment)cGroup_3_1.eContents().get(3);
		private final RuleCall cCloseNameIDTerminalRuleCall_3_1_3_0 = (RuleCall)cCloseNameAssignment_3_1_3.eContents().get(0);
		private final RuleCall cTAG_ENDTerminalRuleCall_3_1_4 = (RuleCall)cGroup_3_1.eContents().get(4);
		
		/// *
		// * FIXME: 'HtmlTag' should not support the 'closeName' feature. The closeName is only needed for
		// * validation to check if the tag is opened and closed with the same name.
		// * / HtmlTag hidden(WS, HTML_COMMENT):
		//	TAG_START name=ID attributes+=HtmlAttr* (selfClosing?=TAG_END_CLOSE | TAG_END children+=HtmlContent* TAG_START_CLOSE
		//	closeName=ID TAG_END);
		public ParserRule getRule() { return rule; }

		//TAG_START name=ID attributes+=HtmlAttr* (selfClosing?=TAG_END_CLOSE | TAG_END children+=HtmlContent* TAG_START_CLOSE
		//closeName=ID TAG_END)
		public Group getGroup() { return cGroup; }

		//TAG_START
		public RuleCall getTAG_STARTTerminalRuleCall_0() { return cTAG_STARTTerminalRuleCall_0; }

		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }

		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }

		//attributes+=HtmlAttr*
		public Assignment getAttributesAssignment_2() { return cAttributesAssignment_2; }

		//HtmlAttr
		public RuleCall getAttributesHtmlAttrParserRuleCall_2_0() { return cAttributesHtmlAttrParserRuleCall_2_0; }

		//selfClosing?=TAG_END_CLOSE | TAG_END children+=HtmlContent* TAG_START_CLOSE closeName=ID TAG_END
		public Alternatives getAlternatives_3() { return cAlternatives_3; }

		//selfClosing?=TAG_END_CLOSE
		public Assignment getSelfClosingAssignment_3_0() { return cSelfClosingAssignment_3_0; }

		//TAG_END_CLOSE
		public RuleCall getSelfClosingTAG_END_CLOSETerminalRuleCall_3_0_0() { return cSelfClosingTAG_END_CLOSETerminalRuleCall_3_0_0; }

		//TAG_END children+=HtmlContent* TAG_START_CLOSE closeName=ID TAG_END
		public Group getGroup_3_1() { return cGroup_3_1; }

		//TAG_END
		public RuleCall getTAG_ENDTerminalRuleCall_3_1_0() { return cTAG_ENDTerminalRuleCall_3_1_0; }

		//children+=HtmlContent*
		public Assignment getChildrenAssignment_3_1_1() { return cChildrenAssignment_3_1_1; }

		//HtmlContent
		public RuleCall getChildrenHtmlContentParserRuleCall_3_1_1_0() { return cChildrenHtmlContentParserRuleCall_3_1_1_0; }

		//TAG_START_CLOSE
		public RuleCall getTAG_START_CLOSETerminalRuleCall_3_1_2() { return cTAG_START_CLOSETerminalRuleCall_3_1_2; }

		//closeName=ID
		public Assignment getCloseNameAssignment_3_1_3() { return cCloseNameAssignment_3_1_3; }

		//ID
		public RuleCall getCloseNameIDTerminalRuleCall_3_1_3_0() { return cCloseNameIDTerminalRuleCall_3_1_3_0; }

		//TAG_END
		public RuleCall getTAG_ENDTerminalRuleCall_3_1_4() { return cTAG_ENDTerminalRuleCall_3_1_4; }
	}

	public class HtmlAttrElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "HtmlAttr");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameIDTerminalRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final RuleCall cWSTerminalRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final RuleCall cASSIGNTerminalRuleCall_2 = (RuleCall)cGroup.eContents().get(2);
		private final RuleCall cWSTerminalRuleCall_3 = (RuleCall)cGroup.eContents().get(3);
		private final Assignment cValueAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cValueATTR_VALUETerminalRuleCall_4_0 = (RuleCall)cValueAssignment_4.eContents().get(0);
		
		//HtmlAttr:
		//	name=ID WS? ASSIGN WS? value=ATTR_VALUE;
		public ParserRule getRule() { return rule; }

		//name=ID WS? ASSIGN WS? value=ATTR_VALUE
		public Group getGroup() { return cGroup; }

		//name=ID
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//ID
		public RuleCall getNameIDTerminalRuleCall_0_0() { return cNameIDTerminalRuleCall_0_0; }

		//WS?
		public RuleCall getWSTerminalRuleCall_1() { return cWSTerminalRuleCall_1; }

		//ASSIGN
		public RuleCall getASSIGNTerminalRuleCall_2() { return cASSIGNTerminalRuleCall_2; }

		//WS?
		public RuleCall getWSTerminalRuleCall_3() { return cWSTerminalRuleCall_3; }

		//value=ATTR_VALUE
		public Assignment getValueAssignment_4() { return cValueAssignment_4; }

		//ATTR_VALUE
		public RuleCall getValueATTR_VALUETerminalRuleCall_4_0() { return cValueATTR_VALUETerminalRuleCall_4_0; }
	}
	
	
	private final HtmlLabelElements pHtmlLabel;
	private final HtmlContentElements pHtmlContent;
	private final HtmlTagElements pHtmlTag;
	private final HtmlAttrElements pHtmlAttr;
	private final TerminalRule tHTML_COMMENT;
	private final TerminalRule tTAG_START_CLOSE;
	private final TerminalRule tTAG_START;
	private final TerminalRule tTAG_END;
	private final TerminalRule tTAG_END_CLOSE;
	private final TerminalRule tASSIGN;
	private final TerminalRule tATTR_VALUE;
	private final TerminalRule tID;
	private final TerminalRule tWS;
	private final TerminalRule tTEXT;
	
	private final Grammar grammar;

	@Inject
	public DotHtmlLabelGrammarAccess(GrammarProvider grammarProvider) {
		this.grammar = internalFindGrammar(grammarProvider);
		this.pHtmlLabel = new HtmlLabelElements();
		this.pHtmlContent = new HtmlContentElements();
		this.pHtmlTag = new HtmlTagElements();
		this.pHtmlAttr = new HtmlAttrElements();
		this.tHTML_COMMENT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "HTML_COMMENT");
		this.tTAG_START_CLOSE = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "TAG_START_CLOSE");
		this.tTAG_START = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "TAG_START");
		this.tTAG_END = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "TAG_END");
		this.tTAG_END_CLOSE = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "TAG_END_CLOSE");
		this.tASSIGN = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "ASSIGN");
		this.tATTR_VALUE = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "ATTR_VALUE");
		this.tID = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "ID");
		this.tWS = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "WS");
		this.tTEXT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "TEXT");
	}
	
	protected Grammar internalFindGrammar(GrammarProvider grammarProvider) {
		Grammar grammar = grammarProvider.getGrammar(this);
		while (grammar != null) {
			if ("org.eclipse.gef.dot.internal.language.DotHtmlLabel".equals(grammar.getName())) {
				return grammar;
			}
			List<Grammar> grammars = grammar.getUsedGrammars();
			if (!grammars.isEmpty()) {
				grammar = grammars.iterator().next();
			} else {
				return null;
			}
		}
		return grammar;
	}
	
	
	public Grammar getGrammar() {
		return grammar;
	}
	

	
	/// * 
	// * This grammar comes with a custom lexer to scan HTML-like labels. Such a label is surrounded
	// * by angle brackets ('<' and '>') in the host Dot language. However, this grammar is used to
	// * analyze the contents of such strings.
	// * / HtmlLabel:
	//	parts+=HtmlContent*;
	public HtmlLabelElements getHtmlLabelAccess() {
		return pHtmlLabel;
	}
	
	public ParserRule getHtmlLabelRule() {
		return getHtmlLabelAccess().getRule();
	}

	//HtmlContent:
	//	tag=HtmlTag | text=TEXT;
	public HtmlContentElements getHtmlContentAccess() {
		return pHtmlContent;
	}
	
	public ParserRule getHtmlContentRule() {
		return getHtmlContentAccess().getRule();
	}

	/// *
	// * FIXME: 'HtmlTag' should not support the 'closeName' feature. The closeName is only needed for
	// * validation to check if the tag is opened and closed with the same name.
	// * / HtmlTag hidden(WS, HTML_COMMENT):
	//	TAG_START name=ID attributes+=HtmlAttr* (selfClosing?=TAG_END_CLOSE | TAG_END children+=HtmlContent* TAG_START_CLOSE
	//	closeName=ID TAG_END);
	public HtmlTagElements getHtmlTagAccess() {
		return pHtmlTag;
	}
	
	public ParserRule getHtmlTagRule() {
		return getHtmlTagAccess().getRule();
	}

	//HtmlAttr:
	//	name=ID WS? ASSIGN WS? value=ATTR_VALUE;
	public HtmlAttrElements getHtmlAttrAccess() {
		return pHtmlAttr;
	}
	
	public ParserRule getHtmlAttrRule() {
		return getHtmlAttrAccess().getRule();
	}

	//// if not tag-mode
	//terminal HTML_COMMENT:
	//	"<!--" (!"-" | "-" !"-" | "-" "-" !">")* "-->";
	public TerminalRule getHTML_COMMENTRule() {
		return tHTML_COMMENT;
	} 

	//// if not tag-mode: tag-mode=true
	//terminal TAG_START_CLOSE:
	//	"</";
	public TerminalRule getTAG_START_CLOSERule() {
		return tTAG_START_CLOSE;
	} 

	//// if not tag-mode: tag-mode=true
	//terminal TAG_START:
	//	"<";
	public TerminalRule getTAG_STARTRule() {
		return tTAG_START;
	} 

	//// if tag-mode: tag-mode=false
	//terminal TAG_END:
	//	">";
	public TerminalRule getTAG_ENDRule() {
		return tTAG_END;
	} 

	//// if tag-mode: tag-mode=false
	//terminal TAG_END_CLOSE:
	//	"/>";
	public TerminalRule getTAG_END_CLOSERule() {
		return tTAG_END_CLOSE;
	} 

	//// if tag-mode
	//terminal ASSIGN:
	//	"=";
	public TerminalRule getASSIGNRule() {
		return tASSIGN;
	} 

	//// if tag-mode
	//terminal ATTR_VALUE:
	//	"\""->"\"";
	public TerminalRule getATTR_VALUERule() {
		return tATTR_VALUE;
	} 

	//// if tag-mode
	//terminal ID:
	//	("_" | "a".."z" | "A".."Z") ("_" | "-" | "a".."z" | "A".."Z" | "0".."9")*;
	public TerminalRule getIDRule() {
		return tID;
	} 

	//// if tag-mode
	//terminal WS:
	//	(" " | "\t" | "\n" | "\r" | "\f")+;
	public TerminalRule getWSRule() {
		return tWS;
	} 

	//// if not tag-mode terminal TEXT:
	//	!("<" | "\"")+;
	public TerminalRule getTEXTRule() {
		return tTEXT;
	} 
}
