/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.internal.storage.io.BlockSource;
import org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.util.RefList;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command
class BenchmarkReftable
extends TextBuiltin {
    @Option(name="--tries")
    private int tries = 10;
    @Option(name="--test")
    private Test test = Test.SCAN;
    @Option(name="--ref")
    private String ref;
    @Option(name="--object-id")
    private String objectId;
    @Argument(index=0)
    private String lsRemotePath;
    @Argument(index=1)
    private String reftablePath;

    BenchmarkReftable() {
    }

    @Override
    protected void run() throws Exception {
        switch (this.test) {
            case SCAN: {
                this.scan();
                break;
            }
            case SEEK_COLD: {
                this.seekCold(this.ref);
                break;
            }
            case SEEK_HOT: {
                this.seekHot(this.ref);
                break;
            }
            case BY_ID_COLD: {
                this.byIdCold(ObjectId.fromString((String)this.objectId));
                break;
            }
            case BY_ID_HOT: {
                this.byIdHot(ObjectId.fromString((String)this.objectId));
            }
        }
    }

    private void printf(String fmt, Object ... args) throws IOException {
        this.errw.println(String.format(fmt, args));
    }

    private void scan() throws Exception {
        int i;
        long start = System.currentTimeMillis();
        for (i = 0; i < this.tries; ++i) {
            this.readLsRemote();
        }
        long tot = System.currentTimeMillis() - start;
        this.printf("%12s %10d ms  %6d ms/run", "packed-refs", tot, tot / (long)this.tries);
        start = System.currentTimeMillis();
        for (i = 0; i < this.tries; ++i) {
            try (FileInputStream in = new FileInputStream(this.reftablePath);
                 BlockSource src = BlockSource.from((FileInputStream)in);
                 ReftableReader reader = new ReftableReader(src);
                 RefCursor rc = reader.allRefs();){
                while (rc.next()) {
                    rc.getRef();
                }
                continue;
            }
        }
        tot = System.currentTimeMillis() - start;
        this.printf("%12s %10d ms  %6d ms/run", "reftable", tot, tot / (long)this.tries);
    }

    private RefList<Ref> readLsRemote() throws IOException, FileNotFoundException {
        RefList.Builder list = new RefList.Builder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.lsRemotePath), StandardCharsets.UTF_8));){
            String line;
            Object last = null;
            while ((line = br.readLine()) != null) {
                ObjectId id = ObjectId.fromString((String)line.substring(0, 40));
                String name = line.substring(41, line.length());
                if (last != null && name.endsWith("^{}")) {
                    last = new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, last.getName(), last.getObjectId(), id);
                    list.set(list.size() - 1, (Ref)last);
                    continue;
                }
                last = name.equals("HEAD") ? new SymbolicRef(name, (Ref)new ObjectIdRef.Unpeeled(Ref.Storage.NEW, "refs/heads/master", null)) : new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, name, id);
                list.add((Ref)last);
            }
        }
        list.sort();
        return list.toRefList();
    }

    private void seekCold(String refName) throws Exception {
        int i;
        int lsTries = Math.min(this.tries, 64);
        long start = System.nanoTime();
        for (i = 0; i < lsTries; ++i) {
            this.readLsRemote().get(refName);
        }
        long tot = System.nanoTime() - start;
        this.printf("%12s %10d usec  %9.1f usec/run  %5d runs", "packed-refs", tot / 1000L, (double)tot / (double)lsTries / 1000.0, lsTries);
        start = System.nanoTime();
        for (i = 0; i < this.tries; ++i) {
            try (FileInputStream in = new FileInputStream(this.reftablePath);
                 BlockSource src = BlockSource.from((FileInputStream)in);
                 ReftableReader reader = new ReftableReader(src);
                 RefCursor rc = reader.seekRef(refName);){
                while (rc.next()) {
                    rc.getRef();
                }
                continue;
            }
        }
        tot = System.nanoTime() - start;
        this.printf("%12s %10d usec  %9.1f usec/run  %5d runs", "reftable", tot / 1000L, (double)tot / (double)this.tries / 1000.0, this.tries);
    }

    private void seekHot(String refName) throws Exception {
        int lsTries = Math.min(this.tries, 64);
        long start = System.nanoTime();
        RefList<Ref> lsRemote = this.readLsRemote();
        for (int i = 0; i < lsTries; ++i) {
            lsRemote.get(refName);
        }
        long tot = System.nanoTime() - start;
        this.printf("%12s %10d usec  %9.1f usec/run  %5d runs", "packed-refs", tot / 1000L, (double)tot / (double)lsTries / 1000.0, lsTries);
        start = System.nanoTime();
        try (FileInputStream in = new FileInputStream(this.reftablePath);
             BlockSource src = BlockSource.from((FileInputStream)in);
             ReftableReader reader = new ReftableReader(src);){
            for (int i = 0; i < this.tries; ++i) {
                try (RefCursor rc = reader.seekRef(refName);){
                    while (rc.next()) {
                        rc.getRef();
                    }
                    continue;
                }
            }
        }
        tot = System.nanoTime() - start;
        this.printf("%12s %10d usec  %9.1f usec/run  %5d runs", "reftable", tot / 1000L, (double)tot / (double)this.tries / 1000.0, this.tries);
    }

    private void byIdCold(ObjectId id) throws Exception {
        int i;
        int lsTries = Math.min(this.tries, 64);
        long start = System.nanoTime();
        for (i = 0; i < lsTries; ++i) {
            for (Ref r : this.readLsRemote()) {
                if (!id.equals((AnyObjectId)r.getObjectId())) continue;
            }
        }
        long tot = System.nanoTime() - start;
        this.printf("%12s %10d usec  %9.1f usec/run  %5d runs", "packed-refs", tot / 1000L, (double)tot / (double)lsTries / 1000.0, lsTries);
        start = System.nanoTime();
        for (i = 0; i < this.tries; ++i) {
            try (FileInputStream in = new FileInputStream(this.reftablePath);
                 BlockSource src = BlockSource.from((FileInputStream)in);
                 ReftableReader reader = new ReftableReader(src);
                 RefCursor rc = reader.byObjectId((AnyObjectId)id);){
                while (rc.next()) {
                    rc.getRef();
                }
                continue;
            }
        }
        tot = System.nanoTime() - start;
        this.printf("%12s %10d usec  %9.1f usec/run  %5d runs", "reftable", tot / 1000L, (double)tot / (double)this.tries / 1000.0, this.tries);
    }

    private void byIdHot(ObjectId id) throws Exception {
        int lsTries = Math.min(this.tries, 64);
        long start = System.nanoTime();
        RefList<Ref> lsRemote = this.readLsRemote();
        for (int i = 0; i < lsTries; ++i) {
            for (Ref r : lsRemote) {
                if (!id.equals((AnyObjectId)r.getObjectId())) continue;
            }
        }
        long tot = System.nanoTime() - start;
        this.printf("%12s %10d usec  %9.1f usec/run  %5d runs", "packed-refs", tot / 1000L, (double)tot / (double)lsTries / 1000.0, lsTries);
        start = System.nanoTime();
        FileInputStream in = new FileInputStream(this.reftablePath);
        Object object = null;
        try (BlockSource src = BlockSource.from((FileInputStream)in);
             ReftableReader reader = new ReftableReader(src);){
            for (int i = 0; i < this.tries; ++i) {
                try (RefCursor rc = reader.byObjectId((AnyObjectId)id);){
                    while (rc.next()) {
                        rc.getRef();
                    }
                    continue;
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            BenchmarkReftable.$closeResource((Throwable)object, in);
        }
        tot = System.nanoTime() - start;
        this.printf("%12s %10d usec  %9.1f usec/run  %5d runs", "reftable", tot / 1000L, (double)tot / (double)this.tries / 1000.0, this.tries);
    }

    static enum Test {
        SCAN,
        SEEK_COLD,
        SEEK_HOT,
        BY_ID_COLD,
        BY_ID_HOT;

    }
}

