/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.dialogs.NewCommentDialog;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class EditCommentHandler
extends AbstractSelectionBasedHandler {
    public Object executeImpl(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof AbstractJBEditor) {
            final AbstractJBEditor tce = (AbstractJBEditor)activePart;
            tce.getEditorHelper().doEditorOperation(new IEditorOperation(){

                @Override
                public void run(IPersistentObject workingPo) {
                    INodePO workTC = (INodePO)workingPo;
                    IStructuredSelection selection = EditCommentHandler.this.getSelection();
                    ICommentPO selectedNode = (ICommentPO)selection.getFirstElement();
                    EditCommentHandler.this.editComment(workTC, selectedNode, tce);
                }
            });
        }
        return null;
    }

    private void editComment(INodePO workTC, ICommentPO comment, AbstractJBEditor editor) {
        NewCommentDialog dialog = new NewCommentDialog(this.getActiveShell(), comment);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return;
        }
        comment.setName(dialog.getCommentText());
        editor.getEditorHelper().setDirty(true);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)comment, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
    }
}

