/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers.project;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jubula.client.core.persistence.CompNamePM;
import org.eclipse.jubula.client.core.persistence.DatabaseConnectionInfo;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnection;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnectionConverter;
import org.eclipse.jubula.client.core.preferences.database.H2ConnectionInfo;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.businessprocess.SecurePreferenceBP;
import org.eclipse.jubula.client.ui.dialogs.DBLoginDialog;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSelectDatabaseHandler
extends AbstractHandler {
    private static Logger log = LoggerFactory.getLogger(AbstractSelectDatabaseHandler.class);
    private static final String DB_COMMAND_PARAMETER = "org.eclipse.jubula.client.ui.selectDatabaseParameter";

    public static boolean shouldAutoConnectToDB() {
        return !"".equals(Plugin.getDefault().getPreferenceStore().getString("AUTOMATIC_DATABASE_CONNECTION_KEY"));
    }

    public Object executeImpl(ExecutionEvent event) {
        String explicitSelectionValue = event.getParameter(DB_COMMAND_PARAMETER);
        boolean explicitSelection = Boolean.valueOf(explicitSelectionValue);
        IStatus returnStatus = Status.CANCEL_STATUS;
        boolean performLogin = false;
        String userName = "";
        String pwd = "";
        DatabaseConnectionInfo dbInfo = null;
        Credential credentials = new Credential(DatabaseConnectionConverter.computeAvailableConnections());
        if (credentials.checkH2DatabaseConnection()) {
            credentials.setH2DatabaseCredentials();
            dbInfo = credentials.getDatabaseInfo();
            userName = credentials.getDBusername();
            pwd = credentials.getDBpassword();
            performLogin = true;
        } else if (explicitSelection || !AbstractSelectDatabaseHandler.shouldAutoConnectToDB()) {
            DBLoginDialog dialog = new DBLoginDialog(this.getActiveShell());
            dialog.create();
            DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                userName = dialog.getUser();
                pwd = dialog.getPwd();
                dbInfo = dialog.getDatabaseConnection().getConnectionInfo();
                performLogin = true;
            }
        } else if (AbstractSelectDatabaseHandler.shouldAutoConnectToDB()) {
            credentials.setAutoConnCredentials();
            dbInfo = credentials.getDatabaseInfo();
            userName = credentials.getDBusername();
            pwd = credentials.getDBpassword();
            performLogin = true;
        }
        if (performLogin) {
            try {
                returnStatus = this.connectToDatabase(userName, pwd, dbInfo);
            }
            catch (InterruptedException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        while (performLogin && returnStatus == null) {
            returnStatus = this.createLoginDialogAgain();
        }
        Persistor.setUser(null);
        Persistor.setPw(null);
        return returnStatus;
    }

    private IStatus connectToDatabase(final String username, final String pwd, final DatabaseConnectionInfo info) throws InterruptedException {
        final AtomicReference<IStatus> returnStatus = new AtomicReference<IStatus>(Status.CANCEL_STATUS);
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.PluginConnectProgress, -1);
                    AbstractSelectDatabaseHandler.this.clearClient();
                    Persistor.setUser((String)username);
                    Persistor.setPw((String)pwd);
                    Persistor.setDbConnectionName((DatabaseConnectionInfo)info);
                    if (Persistor.instance() != null) {
                        CompNamePM.dispose();
                        GeneralStorage.getInstance().dispose();
                        if (LockManager.isRunning()) {
                            LockManager.instance().dispose();
                        }
                        Persistor.instance().dispose();
                    }
                    if (Persistor.init()) {
                        LockManager.instance();
                        AbstractSelectDatabaseHandler.this.writeLineToConsole(Messages.SelectDatabaseConnectSuccessful);
                        returnStatus.set(Status.OK_STATUS);
                    } else {
                        IPreferenceStore store = Plugin.getDefault().getPreferenceStore();
                        store.setToDefault("AUTOMATIC_DATABASE_CONNECTION_KEY");
                        returnStatus.set(null);
                        AbstractSelectDatabaseHandler.this.writeLineToConsole(Messages.SelectDatabaseConnectFailed);
                    }
                }
            });
        }
        catch (InvocationTargetException ite) {
            log.error(ite.getLocalizedMessage(), ite.getCause());
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        return returnStatus.get();
    }

    private IStatus createLoginDialogAgain() {
        IStatus returnStatus = Status.CANCEL_STATUS;
        boolean performLogin = false;
        String userName = "";
        String pwd = "";
        DatabaseConnectionInfo dbInfo = null;
        DBLoginDialog dialog = new DBLoginDialog(this.getActiveShell());
        dialog.create();
        dialog.setErrorMessage(Messages.DatabaseConnectionErrorMessage);
        dialog.getErrorMessage();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            userName = dialog.getUser();
            pwd = dialog.getPwd();
            dbInfo = dialog.getDatabaseConnection().getConnectionInfo();
            performLogin = true;
        }
        if (performLogin) {
            try {
                returnStatus = this.connectToDatabase(userName, pwd, dbInfo);
            }
            catch (InterruptedException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return returnStatus;
    }

    protected abstract void clearClient();

    protected abstract void writeLineToConsole(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Credential {
        private List<DatabaseConnection> m_availableDbConnections;
        private DatabaseConnectionInfo m_dbInfo;
        private String m_userName;
        private String m_pwd;

        private Credential(List<DatabaseConnection> connections) {
            this.m_availableDbConnections = connections;
        }

        private boolean checkH2DatabaseConnection() {
            boolean h2DB = false;
            if (this.m_availableDbConnections.size() == 1 && this.m_availableDbConnections.get(0).getConnectionInfo() instanceof H2ConnectionInfo) {
                h2DB = true;
            }
            return h2DB;
        }

        private void setH2DatabaseCredentials() {
            this.m_dbInfo = this.m_availableDbConnections.get(0).getConnectionInfo();
            this.m_userName = this.m_dbInfo.getProperty("javax.persistence.jdbc.user");
            this.m_pwd = this.m_dbInfo.getProperty("javax.persistence.jdbc.password");
        }

        private void setAutoConnCredentials() {
            IPreferenceStore store = Plugin.getDefault().getPreferenceStore();
            for (DatabaseConnection currentConnection : this.m_availableDbConnections) {
                String profileName = currentConnection.getName();
                if (!profileName.equals(store.getString("AUTOMATIC_DATABASE_CONNECTION_KEY"))) continue;
                this.m_dbInfo = currentConnection.getConnectionInfo();
                SecurePreferenceBP spBP = SecurePreferenceBP.getInstance();
                this.m_userName = spBP.getUserName(profileName);
                this.m_pwd = spBP.getPassword(profileName);
            }
        }

        private DatabaseConnectionInfo getDatabaseInfo() {
            return this.m_dbInfo;
        }

        private String getDBusername() {
            return this.m_userName;
        }

        private String getDBpassword() {
            return this.m_pwd;
        }
    }
}

