/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre.bcel;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantUtf8;

public class ConstantPool
extends org.apache.bcel.classfile.ConstantPool {
    static Constant DONT_CARE_CONSTANT = new ConstantInteger(13);
    static Constant DONT_CARE_CONSTANT_WIDE = new ConstantLong(42L);

    ConstantPool(DataInputStream file) throws IOException {
        super(ConstantPool.readConstants(file));
    }

    static Constant[] readConstants(DataInputStream file) throws IOException {
        int constant_pool_count = file.readUnsignedShort();
        Constant[] constant_pool = new Constant[constant_pool_count];
        int i = 1;
        while (i < constant_pool_count) {
            constant_pool[i] = ConstantPool.readConstant(file);
            byte tag = constant_pool[i].getTag();
            if (tag == 6 || tag == 5) {
                ++i;
            }
            ++i;
        }
        return constant_pool;
    }

    static final Constant readConstant(DataInputStream file) throws IOException, ClassFormatException {
        byte b = file.readByte();
        switch (b) {
            case 7: {
                return new ConstantClass(file.readUnsignedShort());
            }
            case 9: {
                return new ConstantFieldref(file.readUnsignedShort(), file.readUnsignedShort());
            }
            case 10: {
                return new ConstantMethodref(file.readUnsignedShort(), file.readUnsignedShort());
            }
            case 11: {
                return new ConstantInterfaceMethodref(file.readUnsignedShort(), file.readUnsignedShort());
            }
            case 8: {
                file.readUnsignedShort();
                break;
            }
            case 3: {
                file.readInt();
                break;
            }
            case 4: {
                file.readFloat();
                break;
            }
            case 5: {
                file.readLong();
                return DONT_CARE_CONSTANT_WIDE;
            }
            case 6: {
                file.readDouble();
                return DONT_CARE_CONSTANT_WIDE;
            }
            case 12: {
                return new ConstantNameAndType(file.readUnsignedShort(), file.readUnsignedShort());
            }
            case 1: {
                return new ConstantUtf8(file.readUTF());
            }
            case 15: {
                file.readByte();
                file.readUnsignedShort();
                break;
            }
            case 16: {
                file.readUnsignedShort();
                break;
            }
            case 18: {
                file.readUnsignedShort();
                file.readUnsignedShort();
                break;
            }
            default: {
                throw new ClassFormatException("Invalid byte tag in constant pool: " + b);
            }
        }
        return DONT_CARE_CONSTANT;
    }
}

