/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.papyrus.infra.core.Activator;

public class JobExecutorService
extends AbstractExecutorService {
    private final ExecutorJob job = new ExecutorJob();

    @Override
    public void shutdown() {
        this.job.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.job.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.job.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.job.isDone();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.job.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.job.add(command);
    }

    private static class ExecutorJob
    extends Job {
        private static final AtomicInteger count = new AtomicInteger();
        private final AtomicBoolean shuttingDown = new AtomicBoolean();
        private final AtomicBoolean done = new AtomicBoolean();
        private final Lock lock = new ReentrantLock();
        private final Condition doneCond = this.lock.newCondition();
        private final Runnable poisonPill = new Runnable(){

            @Override
            public void run() {
            }
        };
        private Queue<Runnable> workQueue;

        ExecutorJob() {
            super("ExecutorJob-" + count.incrementAndGet());
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.lock.lock();
            try {
                Runnable next = this.workQueue.poll();
                while (next != null) {
                    block11: {
                        if (next == this.poisonPill) {
                            this.setDone();
                            break;
                        }
                        this.lock.unlock();
                        try {
                            try {
                                next.run();
                            }
                            catch (Exception e) {
                                Activator.log.error("Uncaught exception in ExecutorJob work item.", (Throwable)e);
                                this.lock.lock();
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            this.lock.lock();
                            throw throwable;
                        }
                        this.lock.lock();
                    }
                    next = this.workQueue.poll();
                }
            }
            finally {
                this.workQueue = null;
                this.lock.unlock();
            }
            return Status.OK_STATUS;
        }

        void add(Runnable workItem) {
            if (this.isShutdown()) {
                throw new RejectedExecutionException("shutting down");
            }
            this.lock.lock();
            try {
                if (this.workQueue == null) {
                    this.workQueue = new LinkedList<Runnable>();
                    this.schedule();
                }
                this.workQueue.offer(workItem);
            }
            finally {
                this.lock.unlock();
            }
        }

        boolean isDone() {
            return this.done.get();
        }

        void shutdown() {
            if (this.shuttingDown.compareAndSet(false, true)) {
                this.lock.lock();
                try {
                    if (this.workQueue == null) {
                        this.setDone();
                    } else {
                        this.workQueue.offer(this.poisonPill);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        boolean isShutdown() {
            return this.shuttingDown.get();
        }

        private void setDone() {
            this.done.set(true);
            this.doneCond.signalAll();
        }

        List<Runnable> shutdownNow() {
            ArrayList result;
            this.shuttingDown.set(true);
            this.lock.lock();
            try {
                if (this.workQueue == null) {
                    result = Collections.emptyList();
                    this.setDone();
                } else {
                    result = Lists.newArrayList(this.workQueue);
                    this.workQueue.clear();
                    result.remove(this.poisonPill);
                    this.workQueue.offer(this.poisonPill);
                }
            }
            finally {
                this.lock.unlock();
            }
            return result;
        }

        boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            boolean result;
            this.lock.lock();
            try {
                result = this.done.get();
                if (!result) {
                    this.doneCond.await(timeout, unit);
                }
                result = this.done.get();
            }
            finally {
                this.lock.unlock();
            }
            return result;
        }
    }
}

