/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FeedbackHelper;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.gmf.runtime.notation.impl.ConnectorImpl;
import org.eclipse.papyrus.uml.diagram.sequence.ObservationLinkMetamodelType;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DurationObservationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ObservationLinkEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.TimeObservationLabelEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineEditPartUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.TimeObservation;

public class ObservationLinkPolicy
extends GraphicalNodeEditPolicy {
    private final EditPart editPart;

    public ObservationLinkPolicy(EditPart editPart) {
        this.editPart = editPart;
    }

    public Command getCommand(Request request) {
        ReconnectRequest rr;
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            if (((CreateUnspecifiedTypeConnectionRequest)request).getElementTypes().contains((Object)ObservationLinkMetamodelType.getInstance())) {
                if ("observation connection start".equals(request.getType())) {
                    return this.getConnectionCreateCommand((CreateConnectionRequest)request);
                }
                if ("observation connection end".equals(request.getType())) {
                    return this.getConnectionCompleteCommand((CreateConnectionRequest)request);
                }
            }
            return null;
        }
        if (request instanceof CreateConnectionRequest) {
            CreateConnectionRequest cc = (CreateConnectionRequest)request;
            if (cc.getNewObject() != null && cc.getNewObject() instanceof ObservationLink) {
                if ("observation connection start".equals(request.getType())) {
                    return this.getConnectionCreateCommand((CreateConnectionRequest)request);
                }
                if ("observation connection end".equals(request.getType())) {
                    return this.getConnectionCompleteCommand((CreateConnectionRequest)request);
                }
            }
            return null;
        }
        if (request instanceof ReconnectRequest && (rr = (ReconnectRequest)request).getConnectionEditPart() instanceof ObservationLinkEditPart) {
            if ("observation reconnect source".equals(request.getType())) {
                return this.getReconnectSourceCommand((ReconnectRequest)request);
            }
            if ("observation reconnect target".equals(request.getType())) {
                return this.getReconnectTargetCommand((ReconnectRequest)request);
            }
        }
        return null;
    }

    public EditPart getTargetEditPart(Request request) {
        if ("observation connection start".equals(request.getType()) || "observation connection end".equals(request.getType()) || "observation reconnect source".equals(request.getType()) || "observation reconnect target".equals(request.getType())) {
            if (request instanceof CreateConnectionRequest && ((CreateConnectionRequest)request).getSourceEditPart() instanceof TimeObservationLabelEditPart && this.getHost() instanceof AbstractMessageEditPart) {
                return null;
            }
            if ("observation reconnect target".equals(request.getType()) && request instanceof ReconnectRequest && ((ReconnectRequest)request).getConnectionEditPart().getSource() instanceof TimeObservationLabelEditPart && this.getHost() instanceof AbstractMessageEditPart) {
                return null;
            }
            return this.getHost();
        }
        return null;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        EditPart host = this.getHost();
        if (host instanceof TimeObservationLabelEditPart) {
            TimeObservationLabelEditPart timeObservationLabelEditPart = (TimeObservationLabelEditPart)host;
            if (timeObservationLabelEditPart.getSourceConnections().size() > 0) {
                return null;
            }
        } else if (host instanceof DurationObservationEditPart) {
            DurationObservationEditPart durationObservationEditPart = (DurationObservationEditPart)host;
            if (durationObservationEditPart.getSourceConnections().size() > 0) {
                return null;
            }
        } else {
            return null;
        }
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_CreateCommand_Connection_Label);
        CreateObservationLinkCommand cmd = new CreateObservationLinkCommand(((GraphicalEditPart)this.editPart).getEditingDomain(), "Create connection command", null);
        cmd.setSourceEditPart(host);
        cmd.setRequest(request);
        cc.compose((IUndoableOperation)cmd);
        ICommandProxy c = new ICommandProxy((ICommand)cc);
        request.setStartCommand((Command)c);
        return c;
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        EditPart sourceEditPart = request.getSourceEditPart();
        if (sourceEditPart instanceof TimeObservationLabelEditPart && !(this.getHost() instanceof LifelineEditPart)) {
            return null;
        }
        if (sourceEditPart instanceof DurationObservationEditPart && !(this.getHost() instanceof AbstractMessageEditPart)) {
            return null;
        }
        ICommandProxy proxy = (ICommandProxy)request.getStartCommand();
        if (proxy == null) {
            return null;
        }
        CompositeCommand result = new CompositeCommand("Add observation link command");
        if (sourceEditPart instanceof TimeObservationLabelEditPart) {
            result.add((IUndoableOperation)new UpdateTimeObservationLinkTargetElementCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), "Update semantic model", null, (Request)request, this.getHost()));
        } else if (sourceEditPart instanceof DurationObservationEditPart) {
            result.add((IUndoableOperation)new UpdateDurationObservationLinkTargetElementCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), "Update semantic model", null, (Request)request, this.getHost()));
        }
        CompositeCommand cc = (CompositeCommand)proxy.getICommand();
        Iterator commandItr = cc.iterator();
        CreateObservationLinkCommand createConnectorViewCommand = (CreateObservationLinkCommand)((Object)commandItr.next());
        createConnectorViewCommand.setSourceEditPart(request.getSourceEditPart());
        createConnectorViewCommand.setTargetEditPart(request.getTargetEditPart());
        result.add((IUndoableOperation)cc);
        return new ICommandProxy((ICommand)result);
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        Command reconnectSourceCommand = super.getReconnectSourceCommand(request);
        ICommandProxy proxy = (ICommandProxy)reconnectSourceCommand;
        CompositeCommand cc = (CompositeCommand)proxy.getICommand();
        if (request.getConnectionEditPart().getSource() instanceof TimeObservationLabelEditPart && this.getHost() instanceof TimeObservationLabelEditPart) {
            TimeObservationLabelEditPart timeObservationLabelEditPart = (TimeObservationLabelEditPart)this.getHost();
            if (timeObservationLabelEditPart.getSourceConnections().size() > 0) {
                return null;
            }
            cc.add((IUndoableOperation)new UpdateTimeObservationLinkSourceElementCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), "Update semantic model", null, request, this.getHost()));
        } else if (request.getConnectionEditPart().getSource() instanceof DurationObservationEditPart && this.getHost() instanceof DurationObservationEditPart) {
            DurationObservationEditPart durationObservationEditPart = (DurationObservationEditPart)this.getHost();
            if (durationObservationEditPart.getSourceConnections().size() > 0) {
                return null;
            }
            cc.add((IUndoableOperation)new UpdateDurationObservationLinkSourceElementCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), "Update semantic model", null, request, this.getHost()));
        }
        return reconnectSourceCommand;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Command reconnectTargetCommand = super.getReconnectTargetCommand(request);
        ICommandProxy proxy = (ICommandProxy)reconnectTargetCommand;
        CompositeCommand cc = (CompositeCommand)proxy.getICommand();
        if (request.getConnectionEditPart().getSource() instanceof TimeObservationLabelEditPart) {
            cc.add((IUndoableOperation)new UpdateTimeObservationLinkTargetElementCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), "Update semantic model", null, (Request)request, this.getHost()));
        } else if (request.getConnectionEditPart().getSource() instanceof DurationObservationEditPart) {
            cc.add((IUndoableOperation)new UpdateDurationObservationLinkTargetElementCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), "Update semantic model", null, (Request)request, this.getHost()));
        }
        return proxy;
    }

    public void showSourceFeedback(Request request) {
        if ("observation connection end".equals(request.getType())) {
            this.showCreationFeedback((CreateConnectionRequest)request);
        }
    }

    protected FeedbackHelper getFeedbackHelper(CreateConnectionRequest request) {
        if (this.feedbackHelper == null) {
            this.feedbackHelper = new FeedbackHelper();
            Point p = request.getLocation();
            this.connectionFeedback = this.createDummyConnection((Request)request);
            this.connectionFeedback.setConnectionRouter(this.getDummyConnectionRouter(request));
            this.connectionFeedback.setSourceAnchor(this.getSourceConnectionAnchor(request));
            this.connectionFeedback.setForegroundColor(ColorConstants.black);
            this.feedbackHelper.setConnection(this.connectionFeedback);
            this.addFeedback((IFigure)this.connectionFeedback);
            this.feedbackHelper.update(null, p);
        }
        return this.feedbackHelper;
    }

    public void showTargetFeedback(Request request) {
        if ("observation connection start".equals(request.getType()) || "observation connection end".equals(request.getType()) || "observation reconnect source".equals(request.getType()) || "observation reconnect target".equals(request.getType())) {
            this.showTargetConnectionFeedback((DropRequest)request);
        }
    }

    public void eraseSourceFeedback(Request request) {
        if ("observation connection end".equals(request.getType())) {
            this.eraseCreationFeedback((CreateConnectionRequest)request);
        }
    }

    public void eraseTargetFeedback(Request request) {
        if ("observation connection start".equals(request.getType()) || "observation connection end".equals(request.getType()) || "observation reconnect source".equals(request.getType()) || "observation reconnect target".equals(request.getType())) {
            this.eraseTargetConnectionFeedback((DropRequest)request);
        }
    }

    private class CreateObservationLinkCommand
    extends AbstractTransactionalCommand {
        private EditPart sourceEditPart;
        private EditPart targetEditPart;
        private CreateConnectionRequest request;
        private ObservationLink c;
        private String newSourceTerminal;

        public CreateObservationLinkCommand(TransactionalEditingDomain domain, String label, List affectedFiles) {
            super(domain, label, affectedFiles);
        }

        public void setSourceEditPart(EditPart sourceEditPart) {
            this.sourceEditPart = sourceEditPart;
        }

        public void setTargetEditPart(EditPart targetEditPart) {
            this.targetEditPart = targetEditPart;
        }

        public void setRequest(CreateConnectionRequest request) {
            this.request = request;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.c = new ObservationLink();
            this.c.setType("observation link");
            this.c.setElement(null);
            View newSourceView = (View)this.sourceEditPart.getModel();
            this.c.setSource(newSourceView);
            ViewUtil.insertChildView((View)newSourceView.getDiagram(), (View)this.c, (int)-1, (boolean)true);
            INodeEditPart ce = (INodeEditPart)this.sourceEditPart;
            ConnectionAnchor sourceAnchor = ce.getSourceConnectionAnchor((Request)this.request);
            this.newSourceTerminal = ce.mapConnectionAnchorToTerminal(sourceAnchor);
            if (this.newSourceTerminal != null) {
                if (this.newSourceTerminal.length() == 0) {
                    this.c.setSourceAnchor(null);
                } else {
                    IdentityAnchor a = (IdentityAnchor)this.c.getSourceAnchor();
                    if (a == null) {
                        a = NotationFactory.eINSTANCE.createIdentityAnchor();
                    }
                    a.setId(this.newSourceTerminal);
                    this.c.setSourceAnchor((Anchor)a);
                }
            }
            this.initCompleteCommand();
            return CommandResult.newOKCommandResult();
        }

        private void initCompleteCommand() {
            if (this.targetEditPart != null) {
                View newTargetView = ((IGraphicalEditPart)this.targetEditPart).getNotationView();
                this.c.setTarget(newTargetView);
                INodeEditPart ce = (INodeEditPart)this.targetEditPart;
                ConnectionAnchor targetAnchor = null;
                if (ce instanceof LifelineEditPart) {
                    LifelineEditPart lifelinePart = (LifelineEditPart)ce;
                    targetAnchor = LifelineEditPartUtil.getNodeFigure(lifelinePart).getTargetConnectionAnchorAt(this.request.getLocation());
                } else {
                    targetAnchor = ce.getTargetConnectionAnchor((Request)this.request);
                }
                String newTargetTerminal = ce.mapConnectionAnchorToTerminal(targetAnchor);
                if (newTargetTerminal != null) {
                    if (newTargetTerminal.length() == 0) {
                        this.c.setTargetAnchor(null);
                    } else {
                        IdentityAnchor a = (IdentityAnchor)this.c.getTargetAnchor();
                        if (a == null) {
                            a = NotationFactory.eINSTANCE.createIdentityAnchor();
                        }
                        a.setId(newTargetTerminal);
                        this.c.setTargetAnchor((Anchor)a);
                    }
                }
                INodeEditPart sourceEditPart = (INodeEditPart)this.request.getSourceEditPart();
                ConnectionAnchor sourceAnchor = sourceEditPart.mapTerminalToConnectionAnchor(this.newSourceTerminal);
                PointList pointList = new PointList();
                if (this.request.getLocation() == null) {
                    pointList.addPoint(sourceAnchor.getLocation(targetAnchor.getReferencePoint()));
                    pointList.addPoint(targetAnchor.getLocation(sourceAnchor.getReferencePoint()));
                } else {
                    pointList.addPoint(sourceAnchor.getLocation(this.request.getLocation()));
                    pointList.addPoint(targetAnchor.getLocation(this.request.getLocation()));
                }
                ArrayList<RelativeBendpoint> newBendpoints = new ArrayList<RelativeBendpoint>();
                int numOfPoints = pointList.size();
                int i = 0;
                while (i < numOfPoints) {
                    Dimension s = pointList.getPoint(i).getDifference(sourceAnchor.getReferencePoint());
                    Dimension t = pointList.getPoint(i).getDifference(targetAnchor.getReferencePoint());
                    newBendpoints.add(new RelativeBendpoint(s.width, s.height, t.width, t.height));
                    i = (short)(i + 1);
                }
                RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
                bendpoints.setPoints(newBendpoints);
                this.c.setBendpoints((Bendpoints)bendpoints);
            }
        }
    }

    public static class ObservationLink
    extends ConnectorImpl {
    }

    private class UpdateDurationObservationLinkSourceElementCommand
    extends AbstractTransactionalCommand {
        private final ReconnectRequest request;
        private EditPart hostPart;
        private DurationObservationEditPart sourceTolEP;
        List<OccurrenceSpecification> occList;

        public UpdateDurationObservationLinkSourceElementCommand(TransactionalEditingDomain domain, String label, List affectedFiles, ReconnectRequest request, EditPart hostPart) {
            super(domain, label, affectedFiles);
            this.occList = Collections.emptyList();
            this.request = request;
            this.sourceTolEP = (DurationObservationEditPart)request.getConnectionEditPart().getSource();
            this.hostPart = hostPart;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.sourceTolEP == this.hostPart) {
                return CommandResult.newCancelledCommandResult();
            }
            View sourceView = (View)this.sourceTolEP.getModel();
            DurationObservation sourceDurationObservation = (DurationObservation)sourceView.getElement();
            DurationObservationEditPart targetDoEP = (DurationObservationEditPart)this.hostPart;
            View targetView = (View)targetDoEP.getModel();
            DurationObservation targetDurationObservation = (DurationObservation)targetView.getElement();
            targetDurationObservation.getEvents().addAll((Collection)sourceDurationObservation.getEvents());
            sourceDurationObservation.getEvents().clear();
            return CommandResult.newOKCommandResult();
        }

        public boolean canExecute() {
            return this.hostPart instanceof DurationObservationEditPart;
        }
    }

    public class UpdateDurationObservationLinkTargetElementCommand
    extends AbstractTransactionalCommand {
        private final Request request;
        private EditPart hostPart;

        public UpdateDurationObservationLinkTargetElementCommand(TransactionalEditingDomain domain, String label, List affectedFiles, Request request, EditPart hostPart) {
            super(domain, label, affectedFiles);
            this.request = request;
            this.hostPart = hostPart;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            DurationObservationEditPart doEP = null;
            if (this.request instanceof CreateConnectionRequest) {
                doEP = (DurationObservationEditPart)((CreateConnectionRequest)this.request).getSourceEditPart();
            } else if (this.request instanceof ReconnectRequest) {
                doEP = (DurationObservationEditPart)((ReconnectRequest)this.request).getConnectionEditPart().getSource();
            }
            View view = (View)doEP.getModel();
            DurationObservation durationObservation = (DurationObservation)view.getElement();
            EList events = durationObservation.getEvents();
            if (this.request instanceof ReconnectRequest) {
                events.clear();
            }
            Map extendedData = this.request.getExtendedData();
            Object paramOcc1 = extendedData.get("Nearest occurrence specification");
            Object paramOcc2 = extendedData.get("Nearest occurrence specification (end)");
            if (paramOcc1 != null && paramOcc2 != null) {
                events.add((Object)((OccurrenceSpecification)paramOcc1));
                events.add((Object)((OccurrenceSpecification)paramOcc2));
            }
            return CommandResult.newOKCommandResult();
        }

        public boolean canExecute() {
            if (this.hostPart instanceof ConnectionNodeEditPart) {
                Map extendedData = this.request.getExtendedData();
                if (this.hostPart instanceof AbstractMessageEditPart) {
                    AbstractMessageEditPart messageEP = (AbstractMessageEditPart)this.hostPart;
                    View view = (View)messageEP.getModel();
                    Message message = (Message)view.getElement();
                    if (message.getSendEvent() != null) {
                        extendedData.put("Nearest occurrence specification", message.getSendEvent());
                    }
                    if (message.getReceiveEvent() != null) {
                        extendedData.put("Nearest occurrence specification (end)", message.getReceiveEvent());
                    }
                }
                if (extendedData.containsKey("Nearest occurrence specification") && extendedData.containsKey("Nearest occurrence specification (end)")) {
                    return true;
                }
            }
            return false;
        }
    }

    private class UpdateTimeObservationLinkSourceElementCommand
    extends AbstractTransactionalCommand {
        private final ReconnectRequest request;
        private EditPart hostPart;
        private TimeObservationLabelEditPart sourceTolEP;
        List<OccurrenceSpecification> occList;

        public UpdateTimeObservationLinkSourceElementCommand(TransactionalEditingDomain domain, String label, List affectedFiles, ReconnectRequest request, EditPart hostPart) {
            super(domain, label, affectedFiles);
            this.occList = Collections.emptyList();
            this.request = request;
            this.sourceTolEP = (TimeObservationLabelEditPart)request.getConnectionEditPart().getSource();
            this.hostPart = hostPart;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.sourceTolEP == this.hostPart) {
                return CommandResult.newCancelledCommandResult();
            }
            View sourceView = (View)this.sourceTolEP.getModel();
            TimeObservation sourceTimeObservation = (TimeObservation)sourceView.getElement();
            TimeObservationLabelEditPart targetTolEP = (TimeObservationLabelEditPart)this.hostPart;
            View targetView = (View)targetTolEP.getModel();
            TimeObservation targetTimeObservation = (TimeObservation)targetView.getElement();
            targetTimeObservation.setEvent(sourceTimeObservation.getEvent());
            sourceTimeObservation.setEvent(null);
            return CommandResult.newOKCommandResult();
        }

        public boolean canExecute() {
            return this.hostPart instanceof TimeObservationLabelEditPart;
        }
    }

    private class UpdateTimeObservationLinkTargetElementCommand
    extends AbstractTransactionalCommand {
        private final Request request;
        private EditPart hostPart;
        List<OccurrenceSpecification> occList;

        public UpdateTimeObservationLinkTargetElementCommand(TransactionalEditingDomain domain, String label, List affectedFiles, Request request, EditPart hostPart) {
            super(domain, label, affectedFiles);
            this.occList = Collections.emptyList();
            this.request = request;
            this.hostPart = hostPart;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            Iterator<OccurrenceSpecification> iterator;
            TimeObservationLabelEditPart tolEP = null;
            if (this.request instanceof CreateConnectionRequest) {
                tolEP = (TimeObservationLabelEditPart)((CreateConnectionRequest)this.request).getSourceEditPart();
            } else if (this.request instanceof ReconnectRequest) {
                tolEP = (TimeObservationLabelEditPart)((ReconnectRequest)this.request).getConnectionEditPart().getSource();
            }
            View view = (View)tolEP.getModel();
            TimeObservation timeObservation = (TimeObservation)view.getElement();
            if (!this.occList.isEmpty() && (iterator = this.occList.iterator()).hasNext()) {
                OccurrenceSpecification occurrence = iterator.next();
                timeObservation.setEvent((NamedElement)occurrence);
            }
            if (timeObservation.getEvent() instanceof MessageOccurrenceSpecification) {
                Point messageOccurrenceLoc = SequenceUtil.findLocationOfMessageOccurrence((GraphicalEditPart)this.hostPart, (MessageOccurrenceSpecification)timeObservation.getEvent());
                this.setRequestLocation(messageOccurrenceLoc);
            } else if (timeObservation.getEvent() instanceof ExecutionOccurrenceSpecification) {
                Point executionOccurrenceLoc = SequenceUtil.findLocationOfExecutionOccurrence((GraphicalEditPart)this.hostPart, (ExecutionOccurrenceSpecification)timeObservation.getEvent());
                this.setRequestLocation(executionOccurrenceLoc);
            }
            return CommandResult.newOKCommandResult();
        }

        private void setRequestLocation(Point occurrenceLoc) {
            if (occurrenceLoc == null) {
                return;
            }
            if (this.request instanceof CreateConnectionRequest) {
                CreateConnectionRequest req = (CreateConnectionRequest)this.request;
                req.setLocation(new Point(req.getLocation().x, occurrenceLoc.y));
            } else if (this.request instanceof ReconnectRequest) {
                ReconnectRequest req = (ReconnectRequest)this.request;
                req.setLocation(new Point(req.getLocation().x, occurrenceLoc.y));
            }
        }

        public boolean canExecute() {
            if (this.hostPart instanceof LifelineEditPart) {
                Point location = null;
                if (this.request instanceof CreateConnectionRequest) {
                    location = ((CreateConnectionRequest)this.request).getLocation();
                } else if (this.request instanceof ReconnectRequest) {
                    location = ((ReconnectRequest)this.request).getLocation();
                }
                Map.Entry<Point, List<OccurrenceSpecification>> eventAndLocation = SequenceUtil.findNearestEvent(location, (LifelineEditPart)this.hostPart);
                this.occList = Collections.emptyList();
                if (eventAndLocation != null) {
                    this.occList = eventAndLocation.getValue();
                }
                if (!this.occList.isEmpty()) {
                    return true;
                }
            }
            return false;
        }
    }
}

