/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.pde.api.tools.ui.internal.markers.NodeFinder;

public class JavadocTagOperation {
    private IMarker fBackingMarker = null;

    public JavadocTagOperation(IMarker marker) {
        this.fBackingMarker = marker;
    }

    protected void setMarker(IMarker marker) {
        this.fBackingMarker = marker;
    }

    protected IMarker getMarker() {
        return this.fBackingMarker;
    }

    protected BodyDeclaration findNode(ICompilationUnit unit) {
        int focalpos = this.getFocalPosition();
        CompilationUnit cunit = this.createAST(unit, focalpos, false);
        NodeFinder finder = new NodeFinder(focalpos);
        cunit.accept((ASTVisitor)finder);
        return finder.getNode();
    }

    protected CompilationUnit createAST(ICompilationUnit unit, int focalposition, boolean resolvebindings) {
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setSource(unit);
        parser.setFocalPosition(focalposition);
        parser.setResolveBindings(resolvebindings);
        Map options = unit.getJavaProject().getOptions(true);
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        parser.setCompilerOptions(options);
        return (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
    }

    protected String[] getMarkerMessageArguments() {
        String arg;
        if (this.fBackingMarker != null && (arg = this.fBackingMarker.getAttribute("messagearguments", null)) != null) {
            return arg.split("#");
        }
        return new String[0];
    }

    protected CompilationUnit createAST(ICompilationUnit unit) {
        return this.createAST(unit, this.getFocalPosition(), false);
    }

    protected int getFocalPosition() {
        if (this.fBackingMarker == null) {
            return 0;
        }
        return this.fBackingMarker.getAttribute("charStart", 0);
    }

    protected int getParentKind(ASTNode node) {
        if (node == null) {
            return -1;
        }
        if (node instanceof TypeDeclaration) {
            return ((TypeDeclaration)node).isInterface() ? 2 : 1;
        }
        return this.getParentKind(node.getParent());
    }

    protected boolean isConstructor(BodyDeclaration body) {
        if (body.getNodeType() == 31) {
            return ((MethodDeclaration)body).isConstructor();
        }
        return false;
    }
}

