/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.inference;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.factor.FactorFactory;
import org.eclipse.recommenders.jayes.inference.IBayesInferer;

public abstract class AbstractInferrer
implements IBayesInferer {
    protected Map<BayesNode, String> evidence = new HashMap<BayesNode, String>();
    protected double[][] beliefs;
    protected boolean beliefsValid;
    protected FactorFactory factory = FactorFactory.defaultFactory();

    public void setFactorFactory(FactorFactory factory) {
        this.factory = factory;
    }

    public FactorFactory getFactory() {
        return this.factory;
    }

    @Override
    public void addEvidence(BayesNode node, String outcome) {
        this.evidence.put(node, outcome);
        this.beliefsValid = false;
    }

    public void removeEvidence(BayesNode node) {
        this.evidence.remove(node);
        this.beliefsValid = false;
    }

    @Override
    public double[] getBeliefs(BayesNode node) {
        if (!this.beliefsValid) {
            this.beliefsValid = true;
            this.updateBeliefs();
        }
        return this.beliefs[node.getId()];
    }

    @Override
    public void setNetwork(BayesNet bayesNet) {
        this.beliefs = new double[bayesNet.getNodes().size()][];
        for (BayesNode n : bayesNet.getNodes()) {
            this.beliefs[n.getId()] = new double[n.getOutcomeCount()];
        }
        this.factory.setReferenceNetwork(bayesNet);
    }

    @Override
    public void setEvidence(Map<BayesNode, String> evidence) {
        this.evidence = evidence;
        this.beliefsValid = false;
    }

    @Override
    public Map<BayesNode, String> getEvidence() {
        return this.evidence;
    }

    protected abstract void updateBeliefs();
}

