/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.news.impl.read;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.recommenders.internal.news.impl.l10n.Messages;
import org.eclipse.recommenders.news.api.NewsItem;
import org.eclipse.recommenders.news.api.read.IReadItemsStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.log.LogService;

public class DefaultReadItemsStore
implements IReadItemsStore {
    private final Path fileLocation;
    private final Set<String> readIds;
    @Nullable
    private LogService logService;

    public DefaultReadItemsStore() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        Path stateLocation = Platform.getStateLocation((Bundle)bundle).toFile().toPath();
        this.fileLocation = stateLocation.resolve("read-items.uris");
        this.readIds = this.intializeReadIds();
    }

    private Set<String> intializeReadIds() {
        ConcurrentSkipListSet<String> readIds = new ConcurrentSkipListSet<String>();
        if (Files.exists(this.fileLocation, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (BufferedReader in = Files.newBufferedReader(this.fileLocation, StandardCharsets.UTF_8);){
                    String line;
                    while ((line = in.readLine()) != null) {
                        String id = line.substring(0, line.length());
                        readIds.add(id);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.logError(Messages.LOG_ERROR_FAILED_TO_INITIALIZE_READ_ITEMS, e);
            }
        }
        return readIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsRead(NewsItem feedItem) {
        String id = feedItem.getId();
        if (this.readIds.add(id)) {
            Path path = this.fileLocation;
            synchronized (path) {
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (BufferedWriter out = Files.newBufferedWriter(this.fileLocation, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
                        out.append(id).append('\r').append('\n');
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.logError(Messages.LOG_ERROR_FAILED_TO_MARKED_AS_READ, e);
                }
            }
        }
    }

    public boolean isRead(NewsItem feedItem) {
        return this.readIds.contains(feedItem.getId());
    }

    public synchronized void bindLogService(LogService logService) {
        this.logService = logService;
    }

    public synchronized void unbindLogService(LogService logService) {
        if (this.logService == logService) {
            this.logService = null;
        }
    }

    private void logError(String message, Throwable e) {
        LogService localLogService = this.logService;
        if (localLogService != null) {
            localLogService.log(1, message, e);
        }
    }
}

