/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.server.commands;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.remote.internal.proxy.server.commands.AbstractServerCommand;
import org.eclipse.remote.proxy.protocol.core.StreamChannel;
import org.eclipse.remote.proxy.protocol.core.exceptions.ProxyException;

public class ServerExecCommand
extends AbstractServerCommand {
    private final List<String> command;
    private final Map<String, String> env;
    private final boolean redirect;
    private final boolean appendEnv;
    private final String directory;
    private final InputStream stdin;
    private final OutputStream stdout;
    private final OutputStream stderr;
    private final DataOutputStream result;
    private final DataInputStream cmd;
    private Process proc;

    public ServerExecCommand(List<String> command, Map<String, String> env, String directory, boolean redirect, boolean appendEnv, StreamChannel chanA, StreamChannel chanB, StreamChannel chanC) {
        this.command = command;
        this.env = env;
        this.directory = directory;
        this.redirect = redirect;
        this.appendEnv = appendEnv;
        this.stdin = chanA.getInputStream();
        this.stdout = chanA.getOutputStream();
        this.stderr = chanB.getOutputStream();
        this.result = new DataOutputStream(chanC.getOutputStream());
        this.cmd = new DataInputStream(chanC.getInputStream());
    }

    @Override
    public void exec() throws ProxyException {
        new Thread((Runnable)new CommandRunner(), this.command.get(0)).start();
    }

    private Forwarder startForwarder(String name, InputStream in, OutputStream out) {
        Forwarder forwarder = new Forwarder(name, in, out);
        Thread thread = new Thread((Runnable)forwarder, String.valueOf(this.command.get(0)) + " " + name);
        thread.start();
        return forwarder;
    }

    private class CommandRunner
    implements Runnable {
        private CommandRunner() {
        }

        @Override
        public void run() {
            ProcessBuilder builder = new ProcessBuilder(ServerExecCommand.this.command);
            try {
                if (!ServerExecCommand.this.appendEnv) {
                    builder.environment().clear();
                    builder.environment().putAll(ServerExecCommand.this.env);
                } else {
                    for (Map.Entry entry : ServerExecCommand.this.env.entrySet()) {
                        String val = builder.environment().get(entry.getKey());
                        if (val != null && val.equals(entry.getValue())) continue;
                        builder.environment().put((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }
            catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {}
            File dir = new File(ServerExecCommand.this.directory);
            if (dir.exists() && dir.isAbsolute()) {
                builder.directory(dir);
            }
            builder.redirectErrorStream(ServerExecCommand.this.redirect);
            try {
                int exit = 0;
                try {
                    ServerExecCommand.this.proc = builder.start();
                    ServerExecCommand.this.startForwarder("stdout", ServerExecCommand.this.proc.getInputStream(), ServerExecCommand.this.stdout);
                    if (!ServerExecCommand.this.redirect) {
                        ServerExecCommand.this.startForwarder("stderr", ServerExecCommand.this.proc.getErrorStream(), ServerExecCommand.this.stderr);
                    }
                    ServerExecCommand.this.startForwarder("stdin", ServerExecCommand.this.stdin, ServerExecCommand.this.proc.getOutputStream());
                    new Thread((Runnable)new ProcMonitor(), "process monitor").start();
                    System.err.println("wait for process");
                    exit = ServerExecCommand.this.proc.waitFor();
                    System.err.println("wait for process close in");
                    System.err.println("wait for readers");
                    System.err.println("wait for readers done");
                }
                catch (IOException e) {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(ServerExecCommand.this.stderr));
                    try {
                        writer.write(e.getMessage());
                        writer.flush();
                    }
                    catch (IOException iOException) {}
                    exit = -1;
                }
                try {
                    ServerExecCommand.this.result.writeInt(exit);
                    ServerExecCommand.this.result.flush();
                }
                catch (IOException iOException) {}
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private class Forwarder
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;
        private final String name;
        private volatile boolean running = true;
        private boolean terminated = false;
        private final Lock lock = new ReentrantLock();
        private final Condition cond = this.lock.newCondition();

        public Forwarder(String name, InputStream in, OutputStream out) {
            this.name = name;
            this.in = new BufferedInputStream(in);
            this.out = new BufferedOutputStream(out);
        }

        @Override
        public void run() {
            byte[] buf = new byte[8192];
            try {
                int n;
                do {
                    if ((n = this.in.read(buf)) > 0) {
                        this.out.write(buf, 0, n);
                        this.out.flush();
                    }
                    if (n != 0) continue;
                    System.err.println("forwarder n=0");
                } while (n >= 0);
            }
            catch (IOException e) {
                System.err.println("forwarder " + e.getMessage());
            }
            System.err.println("forwarder closing name=" + this.name);
            try {
                this.out.close();
            }
            catch (IOException iOException) {}
            this.lock.lock();
            this.terminated = true;
            try {
                this.cond.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void terminate() {
            this.running = false;
        }

        public synchronized void waitFor() {
            this.lock.lock();
            try {
                if (!this.terminated) {
                    try {
                        this.cond.await();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private class ProcMonitor
    implements Runnable {
        private ProcMonitor() {
        }

        @Override
        public void run() {
            try {
                ServerExecCommand.this.cmd.readByte();
                if (ServerExecCommand.this.proc.isAlive()) {
                    ServerExecCommand.this.proc.destroyForcibly();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

